#
ifndef ESP_ROOT
$(error ESP_ROOT must be set -- Please fix the environment...)
endif
ifndef ESP_ARCH
$(error ESP_ARCH must be set -- Please fix the environment...)
endif
#
IDIR  = $(ESP_ROOT)/include
include $(IDIR)/$(ESP_ARCH)
LDIR  = $(ESP_ROOT)/lib

$(LDIR)/myAIM.so:	myAIM.o $(LDIR)/libaimUtil.a
	-rm $(LDIR)/myAIM.so
	$(CC) $(SOFLGS) -o $(LDIR)/myAIM.so myAIM.o \
		-L$(LDIR) -laimUtil -locsm -legads -ludunits2 -ldl $(RPATH) -lm

myAIM.o:	myAIM.cpp $(IDIR)/aimUtil.h $(IDIR)/capsTypes.h
	$(CXX) -c $(CPPOPT) $(DEFINE) -I$(IDIR) myAIM.cpp

test:	$(LDIR)/myAIM.so FORCE
	( cd test; make; rm -rf __pycache__ )

run:	$(LDIR)/myAIM.so FORCE
	python session1.py

FORCE:	;

clean:
	-rm myAIM.o 
	-rm -rf myExample

cleanall:	clean
	-rm $(LDIR)/myAIM.so
