import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aim
myAIM = myProblem.analysis.create(aim = "myAIM")

# Get current value of our first input
value = myAIM.input.num
print("Default num =", value)
myAIM.input.num = 16.0
value = myAIM.input.num
print("Current num =", value)

# AIM autoExecutes

# Get an output
value = myAIM.output.sqrtNum
print("Computed sqrtNum =", value)
assert(value == 4.0)
print(" ")
