import pyCAPS
import unittest
import os
import glob
import shutil

class TestMyAIM(unittest.TestCase):

#==============================================================================
    @classmethod
    def setUpClass(cls):
        # This will only be executed once at startup
        cls.problemName = "myAIMexample"
        cls.iProb = 1
        cls.cleanUp()

    @classmethod
    def tearDownClass(cls):
        # This is only executed once to tear down
        cls.cleanUp()

    @classmethod
    def cleanUp(cls):
        # Remove problem directories
        dirs = glob.glob( cls.problemName + '*')
        for dir in dirs:
            if os.path.isdir(dir):
                shutil.rmtree(dir)

#==============================================================================
    def test_defaultInput(self):
        
        # Instantiate our CAPS problem "capsProblem"
        capsProblem = pyCAPS.Problem(problemName=self.problemName+str(self.iProb),
                                     capsFile="case.csm",
                                     outLevel = 0); self.__class__.iProb += 1

        # Load my aim
        myAIM = capsProblem.analysis.create(aim = "myAIM")

        # Check the default input values
        self.assertEqual(myAIM.input.InputVariable, False)
        self.assertEqual(myAIM.input.num, 8)
        self.assertIsNone(myAIM.input.Mach)
        self.assertIsNone(myAIM.input.Mesh_Format)
        self.assertEqual(myAIM.input.Table, {"Entry1":"Value1","Entry2":"Value2","Entry3":"Value3"})
        print(" ")

#==============================================================================
    def test_setInput(self):
        
        # Instantiate our CAPS problem "capsProblem"
        capsProblem = pyCAPS.Problem(problemName=self.problemName+str(self.iProb),
                                     capsFile="case.csm",
                                     outLevel = 0); self.__class__.iProb += 1

        # Load my aim
        myAIM = capsProblem.analysis.create(aim = "myAIM")
        
        # Try setting inputs
        myAIM.input.InputVariable = True
        myAIM.input.num = 16
        myAIM.input.Mach = 0.5
        myAIM.input.Mesh_Format = ["vtk","stl"]
        myAIM.input.Table = {"fee":42, "fi":2.0, "fum":"yay!"}
        
        # Check the inputs are properly set
        self.assertEqual(myAIM.input.InputVariable, True)
        self.assertEqual(myAIM.input.num, 16)
        self.assertEqual(myAIM.input.Mach, 0.5)
        self.assertEqual(myAIM.input.Mesh_Format, ["vtk","stl"])
        self.assertEqual(myAIM.input.Table, {"fee":42, "fi":2.0, "fum":"yay!"})
        print(" ")

#==============================================================================
    def test_getOutput(self):

        # Instantiate our CAPS problem "capsProblem"
        capsProblem = pyCAPS.Problem(problemName=self.problemName+str(self.iProb),
                                     capsFile="case.csm",
                                     outLevel = 0); self.__class__.iProb += 1

        # Load my aim
        myAIM = capsProblem.analysis.create(aim = "myAIM")

        # Set the input
        myAIM.input.num = 16.0
        
        # AIM autoExecutes
        
        # Check the output
        self.assertAlmostEqual(myAIM.output.sqrtNum, 16**0.5, 8)
        print(" ")

if __name__ == '__main__':
    unittest.main()
