import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aim
myAIM = myProblem.analysis.create(aim = "myAIM")

# Get current value of our first input
value = myAIM.input.num
print("Default num =", value)
myAIM.input.num = 16.0
value = myAIM.input.num
print("Current num =", value)

# AIM autoExecutes

# Get outputs
myGeometry = myProblem.geometry
value = myGeometry.outpmtr["pVol"].value
print(" ")
print("parentVolume =", value)
assert(abs(value - 34.6415248071731) < 1.e-7)
value = myGeometry.outpmtr["cVol"].value
print("childVolume  =", value)
assert(abs(value - 7.296559648508515) < 1.e-7)

value = myAIM.output.sqrtNum
print("sqrtNum      =", value)
assert(value == 4.0)
print(" ")
