# fuleDensSens - AnalysisIn test case for theAIM
# written by John Dannenhoffer

# Imports needed to run either from python or serveESP prompt
import pyCAPS
from   pyOCSM import esp

# Instantiate the "theExample" CAPS problem.  If this
#     script is executed from the python prompt, load
#     the geometry from theAIM_1.csm
print("\nCreating the CAPS Problem...")
theProblem = pyCAPS.Problem(problemName= "theExample",
                            capsFile   = "theAIM.csm")

# Create the AIM
print("\nCreating the AIM...");
theAIM = theProblem.analysis.create(aim        = "theAIM",
                                    capsIntent = "CFD;STRUCTURES")

# Set inputs for the aim (shown two different ways)
print("\nSetting AIM inputs...")
theAIM.input["wallDensity"].value = 0.01      # kg/m2
theAIM.input.fuelDensity          = 0.001     # kg/m3

# Select the variable that we want the sensitivity with respect to
#    (or leave blank if sensitivities are not required)
sensVar  = "fuelDens"
sensType = "ANALYSISIN"

theAIM.input.sensVar = sensVar

# Get the outputs from the geometry
print("\nGetting outputs from geometry...")
geomArea = theProblem.geometry.outpmtr["myArea"].value
geomVol  = theProblem.geometry.outpmtr["myVol" ].value

if sensType != "ANALYSISIN":
    geomArea_dot = theProblem.geometry.outpmtr["myArea"].deriv(sensVar)
    geomVol_dot  = theProblem.geometry.outpmtr["myVol" ].deriv(sensVar)
else:
    geomArea_dot = 0
    geomVol_dot  = 0

print("\nGeometry results:")
print("    area    =", geomArea    )
print("    area_dot=", geomArea_dot)
print("    vol     =", geomVol     )
print("    vol_dot =", geomVol_dot )

# The analysis is executed automatically if an analysis output
#     is requested and (at least) one of the following:
#     * this is the first case
#     * an analysis input  has changed
#     * a geometry DESPMTR has changed

# Extract the answers from the analysis output file
print("\nGetting outputs from the AIM...")
analArea     = theAIM.output["area"].value
analVol      = theAIM.output["vol" ].value
analMass     = theAIM.output["mass"].value

if sensType != "ANALYSISIN":
    analArea_dot = theAIM.output["area"].deriv(sensVar)
    analVol_dot  = theAIM.output["vol" ].deriv(sensVar)
    analMass_dot = theAIM.output["mass"].deriv(sensVar)
else:
    analArea_dot = 0
    analVol_dot  = 0
    analMass_dot = theAIM.output["mass"].deriv(sensVar)

print("\nAnalysis results (for sensitivities wrt " + sensVar + "):")
print("    area    =", analArea    )
print("    area_dot=", analArea_dot)
print("    vol     =", analVol     )
print("    vol_dot =", analVol_dot )
print("    mass    =", analMass    )
print("    mass_dot=", analMass_dot)

# verify that the answers from the geometry and analysis match
print("\nAsserting that geometry and analysis values agree...")
pct_area     = abs(geomArea    -analArea    )/(analArea    +1e-20)*100
pct_area_dot = abs(geomArea_dot-analArea_dot)/(analArea_dot+1e-20)*100
pct_vol      = abs(geomVol     -analVol     )/(analVol     +1e-20)*100
pct_vol_dot  = abs(geomVol_dot -analVol_dot )/(analVol_dot +1e-20)*100

print("    area     difference=", pct_area,     "%")
print("    area_dot difference=", pct_area_dot, "%")
print("    vol      difference=", pct_vol,      "%")
print("    vol_dot  difference=", pct_vol_dot,  "%")

print("\nSuccessfully completed\n")
