import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aims
cfdAIM = myProblem.analysis.create(aim = "myAIM", name="cfd", capsIntent = "CFD")
strAIM = myProblem.analysis.create(aim = "myAIM", name="str", capsIntent = "STRUCTURES")

# Create a Bound and fill it
bTop   = myProblem.bound.create("Top")
VStop  = bTop.vertexSet.create(cfdAIM)
topGsX = VStop.dataSet.create("x[1]", pyCAPS.fType.GeomSens)
bTop.close()

bBot   = myProblem.bound.create("Bottom")
VSbot  = bBot.vertexSet.create(cfdAIM)
botTsX = VSbot.dataSet.create("x[1]", pyCAPS.fType.TessSens)
bBot.close()

# AIM autoExecutes

# Get outputs
topGsX.view()
botTsX.view()
print(" ")
