import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aims
cfdAIM = myProblem.analysis.create(aim = "myAIM", name="cfd", capsIntent = "CFD")
strAIM = myProblem.analysis.create(aim = "myAIM", name="str", capsIntent = "STRUCTURES")

# Create a Bound and fill it
bound = myProblem.bound.create("Interface")
cfdVS = bound.vertexSet.create(cfdAIM)
strVS = bound.vertexSet.create(strAIM)

cfdY  = cfdVS.dataSet.create("yCoor")
strY  = strVS.dataSet.create("in2")
strY.link(cfdY, "Conserve")

cfdZ  = cfdVS.dataSet.create("zCoor")
strZ  = strVS.dataSet.create("in3")
strZ.link(cfdZ, "Conserve")
bound.close()

# AIM autoExecutes

# Get outputs
strY.view()
strZ.view()

print(" ")
print(" Dirty Info: cfdAIM =", cfdAIM.info())
print(" Dirty Info: strAIM =", strAIM.info())
print(" ")
