import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aims
cfdAIM = myProblem.analysis.create(aim = "myAIM", name="cfd")

cfdAIM.input.num = 16.0
cfdAIM.input.meshFile = "myMeshFile"

# AIM autoExecutes

# Get outputs

value = cfdAIM.output.sqrtNum
print("sqrtNum      =", value)
assert(value == 4.0)
value = cfdAIM.dynout["Everything"].value
print("Everything   =", value)
assert(value == 42)
value = cfdAIM.output["Surface_Mesh"].value
print(" ")

