import pyCAPS
from   pyOCSM import esp

# Instantiate our CAPS problem "myProblem"
print("Loading file into our Problem")
myProblem = pyCAPS.Problem(problemName="myExample", capsFile="case.csm")

# Load our session aims
myCFD = myProblem.analysis.create(aim = "myAIM", capsIntent = "CFD")
mySTR = myProblem.analysis.create(aim = "myAIM", capsIntent = "STRUCTURES")

# Link the AIMs
mySTR.input["FileIn"].link(myCFD.output["FileOut"])

# Set current value of our first input
myCFD.input.num = 16.0
mySTR.input.num =  4.0

# AIM autoExecutes

# Get outputs
myGeometry = myProblem.geometry
value = myGeometry.outpmtr["pVol"].value
print(" ")
print("parentVolume =", value)
assert(abs(value - 34.6415248071731) < 1.e-7)
value = myGeometry.outpmtr["cVol"].value
print("childVolume  =", value)
assert(abs(value - 7.296559648508515) < 1.e-7)
print(" ")

value = myCFD.output.sqrtNum
print("sqrtNum (CFD) =", value)
assert(value == 4.0)
value = myCFD.dynout["Everything"].value
print("Everything    =", value)
assert(value == 42)
print(" ")

value = mySTR.output.sqrtNum
print("sqrtNum (STR) =", value)
assert(value == 2.0)
value = mySTR.dynout["Everything"].value
print("Everything    =", value)
assert(value == 42)
print(" ")
