# Imports needed to run either from python or serveESP prompt
import pyCAPS
from   pyOCSM import esp

# Instantiate the "theExample" CAPS problem.  If this
#     script is executed from the python prompt, load
#     the geometry from theAIM.csm
print("\nCreating the CAPS Problem...")
theProblem = pyCAPS.Problem(problemName= "theExample",
                            capsFile   = "theAIM.csm")

# Create the AIM
print("\nCreating the AIM...");
theAIM = theProblem.analysis.create(aim        = "theAIM",
                                    capsIntent = "CFD;STRUCTURES")

# Set inputs for the aim (shown two different ways)
print("\nSetting AIM inputs...")
theAIM.input["wallDensity"].value = 0.01      # kg/m2
theAIM.input.fuelDensity          = 0.001     # kg/m3

# Get the outputs from the geometry (shown only way that works)
print("\nGetting outputs from geometry...")
geomArea = theProblem.geometry.outpmtr["myArea"].value
geomVol  = theProblem.geometry.outpmtr["myVol"].value

print("\nGeometry results:")
print("    area=", geomArea)
print("    vol =", geomVol )

# The analysis is executed automatically if an analysis output
#     is requested and (at least) one of the following:
#     * this is the first case
#     * an analysis input  has changed
#     * a geometry DESPMTR has changed

# Extract the answer from the analysis output file (shown two different ways)
print("\nGetting outputs from the AIM...")
analArea = theAIM.output["area"].value
analVol  = theAIM.output["vol"].value
analMass = theAIM.output.mass

print("\nAnalysis results:")
print("    area=", analArea, " m2")
print("    vol =", analVol,  " m3")
print("    mass=", analMass, " kg")

#-----------------------------------------

# Change the AIM inputs (but no change to geometry)
print("\nChanging AIM inputs...")
theAIM.input["wallDensity"].value = 0.02      # kg/m2
theAIM.input.fuelDensity          = 0.002     # kg/m3

# Run the analysis (automatically)

# Extract the answer from the analysis output file (shown two different ways)
print("\nGetting outputs from the AIM...")
analArea = theAIM.output["area"].value
analVol  = theAIM.output["vol"].value
analMass = theAIM.output.mass

print("\nAnalysis results:")
print("    area=", analArea, " m2")
print("    vol =", analVol,  " m3")
print("    mass=", analMass, " kg")

# verify that the area and volume from the geometry and analysis match
print("\nAsserting that geometry and analysis values agree...")
print("    area difference=", abs(geomArea-analArea)/analArea*100, "%")
print("    vol  difference=", abs(geomVol -analVol )/analVol *100, "%")

assert(abs(geomArea-analArea) < 1e-2)
assert(abs(geomVol -analVol ) < 1e-2)

print("\nSuccessfully completed\n")
