# Imports needed to run either from python or serveESP prompt
import pyCAPS
from   pyOCSM import esp

# Instantiate the "theExample" CAPS problem.  If this
#     script is executed from the python prompt, load
#     the geometry from theAIM.csm
print("\nCreating the CAPS Problem...")
theProblem = pyCAPS.Problem(problemName= "theExample",
                            capsFile   = "theAIM.csm")

# Create the AIM
print("\nCreating the AIM...");
theAIM = theProblem.analysis.create(aim        = "theAIM",
                                    capsIntent = "CFD;STRUCTURES")

# Set the Units we will be using
kg = pyCAPS.Unit("kg")
m  = pyCAPS.Unit("m")
dens = kg/m**3

# Set inputs for the aim
print("\nSetting AIM inputs...")
theAIM.input["wallDensity"].value   = 0.1   * dens
theAIM.input["wallThickness"].value = 0.1   * m
theAIM.input.fuelDensity            = 0.001 * dens

# Get the outputs from the geometry (shown only way that works)
print("\nGetting outputs from geometry...")
geomArea = theProblem.geometry.outpmtr["myArea"].value
geomVol  = theProblem.geometry.outpmtr["myVol"].value

print("\nGeometry results:")
print("    area=", geomArea)
print("    vol =", geomVol )

# The analysis is executed automatically if an analysis output
#     is requested and (at least) one of the following:
#     * this is the first case
#     * an analysis input  has changed
#     * a geometry DESPMTR has changed

# Extract the answer from the analysis output file (shown two different ways)
print("\nGetting outputs from the AIM...")
analArea = theAIM.output["area"].value
analVol  = theAIM.output["vol"].value
analMass = theAIM.output.mass

print("\nAnalysis results:")
print("    area =", analArea)
print("    vol  =", analVol)
print("    mass =", analMass)

#-----------------------------------------

# Change the AIM inputs (but no change to geometry)
print("\nChanging AIM inputs...")
theAIM.input["wallDensity"].value = 0.2   * dens
theAIM.input.fuelDensity          = 0.002 * dens 

# Run the analysis (automatically)

# Extract the answer from the analysis output file (shown two different ways)
print("\nGetting outputs from the AIM...")
analArea = theAIM.output["area"].value
analVol  = theAIM.output["vol"].value
analMass = theAIM.output.mass

print("\nAnalysis results:")
print("    area =", analArea)
print("    vol  =", analVol)
print("    mass =", analMass)
print(" ")
