###################################################################
#                                                                 #
# example.py --- start with either of the following:              #
#                      python example.py       (shows nothing)    #
#                         example.csm                             #
#                      serveESP example                           #
#                         Tool->Pyscript  example                 #
#                                                                 #
#              Written by John Dannenhoffer @ Syracuse University #
#                                                                 #
###################################################################

# import the appropriate packages
from pyEGADS import egads
from pyOCSM  import ocsm
from pyOCSM  import esp

import os

#------------------------------------------------------------------

# callback functions
def pyMesgCB(text):
    print(" ")
    print("======= in pyMesgCB =======")
    print("   ", text.decode())
    print("===========================")
    return

def pySizeCB(modl, ipmtr, nrow, ncol):
    print(" ")
    print("======= in pySizeCB =======")
    print("    ipmtr:", ipmtr)
    print("    nrow :", nrow )
    print("    ncol :", ncol )
    print("===========================")
    return

# make a semi-colon-separated string from a list
def makeString(array):
    out = ""
    for i in array:
        out += str(i) + ";"
    return out

#------------------------------------------------------------------

# run quietly
ocsm.SetOutLevel(0)

# if we are running via serveESP, link to that MODL
try:
    modl = ocsm.Ocsm(esp.GetModl(esp.GetEsp("pyscript")))
    modl.RegMesgCB(pyMesgCB)
    modl.RegSizeCB(pySizeCB)
    print("==> getting MODL from ESP")

# an error means that we are probably running from the python prompt,
#    so get the filename from the user to create a new MODL
except ocsm.OcsmError:
    filename = ""
    while (".csm" not in filename):
        filename = input("Enter name of .csm file: ")
        if (not os.path.exists(filename)):
            print("\""+filename+"\" does not exist")
            filename = ""
    modl = ocsm.Ocsm(filename)
    modl.RegMesgCB(pyMesgCB)
    modl.RegSizeCB(pySizeCB)
    print("==> making new MODL from \""+filename+"\"")

# check the MODL
modl.Check()

# we need a build so that we can get the parameter indices
modl.Build(0, 0)

# find the indicies of ESP's parameters
ilen = modl.FindPmtr("myLen", 0, 0, 0)
ivol = modl.FindPmtr("myVol", 0, 0, 0)

# load the viewer (so that we can see the configuration)
esp.TimLoad("viewer", esp.GetEsp("pyscript"), "")

# show the original configuration and wait for
#    user to press ExitViewer
esp.TimMesg("viewer", "MODL")

# initialize the list in which data to be plotted will be stored
myLen = []
myVol = []

# loop through successively larger cylinders
for len in [0.5, 1.0, 1.5, 2.001, 2.5, 3.0]:

    # set the length
    modl.SetValuD(ilen, 1, 1, len)

    # build the model
    modl.Build(0, 0)

    # show the current configuration and wait to user to ExitViewer
#---     esp.TimMesg("viewer", "MODL")

    # add the data for this case to the data to be plotted
    myLen.append(modl.GetValu(ilen, 1, 0)[0])
    myVol.append(modl.GetValu(ivol, 1, 0)[0])

# quit the viewer so that we can use the plotter
esp.TimQuit("viewer")

# load the plotter (so that can see a line plot)
esp.TimLoad("plotter", esp.GetEsp("pyscript"), "")

# new plot with given axis labels
esp.TimMesg("plotter", "new|example|len|vol|")

# add the line to the plot (solid black line with red + symbols)
esp.TimMesg("plotter", "add|"+makeString(myLen)+"|"+makeString(myVol)+"|k-|")
esp.TimMesg("plotter", "add|"+makeString(myLen)+"|"+makeString(myVol)+"|r+|")

# show the plot
esp.TimMesg("plotter", "show")

# exit the plotter when user presses ExitPlotter
esp.TimQuit("plotter")
