###################################################################
#                                                                 #
# runAflrVis --- run Aflr on wing geometry; plot surface grids    #
#                                                                 #
#              Written by John Dannenhoffer @ Syracuse University #
#                     and Marshall Galbraith @ MIT                #
#                                                                 #
###################################################################

# import pyCAPS module
import pyCAPS
from   pyOCSM import esp

import os

#------------------------------------------------------------------

# load geometry [.csm] file
filename = os.path.join(__file__, "..", "wingCfdVis.csm")

capsProblem = pyCAPS.Problem(problemName = "runAflrVis",
                             capsFile    = filename,
                             outLevel    = 0)

# setup AIM for AFLR
aflr4 = capsProblem.analysis.create(aim  = "aflr4AIM",
                                    name = "aflr4")

# view the geometry with the EGADS tessellation
aflr4.geometry.view()

# mark capsMesh == Farfield with a Farfield bcType
aflr4.input.Mesh_Sizing = {"Farfield": {"bcType":"Farfield"}}

# farfield growth factor
aflr4.input.ff_cdfr = 1.4

# scaling factor to compute AFLR4 'ref_len' parameter via
# ref_len = capsMeshLength * Mesh_Length_Factor
aflr4.input.Mesh_Length_Factor = 5

# relative scale of maximum spacing bound relative to ref_len
# max_spacing = max_scale * ref_len
aflr4.input.max_scale = 0.1

# approximately the degree between points if you were meshing a circle
aflr4.input.curv_angle = 10

# run AIM analysis
aflr4.runAnalysis()

# view the AFLR4 surface tessellation 
aflr4.geometry.view()

# close the capsProblem (required if you want to run another pyscript)
capsProblem.close()
