#!/bin/bash -e

PREFIX="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
INSTALL=$(basename $PREFIX)
PYVER=${INSTALL%.*}
PYVER=${PYVER#*.}

BIN="$PREFIX/bin"
LIB="$PREFIX/lib/python3.${PYVER}"
CONFIG="$LIB/_sysconfigdata__linux_x86_64-linux-gnu.py"
SCRIPTS="`ls $BIN/*` $LIB/config-3.${PYVER}-x86_64-linux-gnu/Makefile $LIB/config-3.${PYVER}-x86_64-linux-gnu/python-config.py `ls $PREFIX/lib/pkgconfig/python*.pc` $CONFIG"
INSTALLPATH=$(echo "${PREFIX}"  | sed 's/\//\\\//g')
for f in $SCRIPTS
do
  if [[ ! $(file -bL --mime $f | grep 'binary') ]]; then
    echo "Patching '$f'"
    sed -i "s/ESP_Python_INSTALL/$INSTALLPATH/g" $f
  fi
done

# Binary file patch inspired by
# https://everydaywithlinux.blogspot.com/2012/11/patch-strings-in-binary-files-with-sed.html?m=1

function patch_strings_binary_file() {
  local FILE="$1"
  local PATTERN="$2"
  local REPLACEMENT="$3"

  # Find all unique strings in FILE that contain the pattern 
  # Replace spaces with @@@@@ so for loop is over each string
  STRINGS=$(strings ${FILE} | grep ${PATTERN} | sort -u -r | sed -e 's/ /@@@@@/g' )

  if [ "${STRINGS}" != "" ] ; then
    #echo "File '${FILE}' contain strings with '${PATTERN}' in them:"
    echo "Patching '${FILE}'"

    #IFS=$'\n'
    for OLD_STRING in ${STRINGS} ; do
      # Create the new string with a simple bash-replacement
      NEW_STRING=${OLD_STRING//${PATTERN}/${REPLACEMENT}}

      # Create null terminated ASCII HEX representations of the strings
      OLD_STRING_HEX="$(echo -n ${OLD_STRING} | xxd -g 0 -u -ps -c 0 | tr -d '\n')00"
      NEW_STRING_HEX="$(echo -n ${NEW_STRING} | xxd -g 0 -u -ps -c 0 | tr -d '\n')00"

      # Put spaces back as xxd will replace multiple spaces with a single space
      AT_HEX="$( echo -n @@@@@ | xxd -g 0 -u -ps -c 0)"
      SPACE_HEX="$( echo -n ' ' | xxd -g 0 -u -ps -c 0)"
      OLD_STRING_HEX=${OLD_STRING_HEX//${AT_HEX}/${SPACE_HEX}}
      NEW_STRING_HEX=${NEW_STRING_HEX//${AT_HEX}/${SPACE_HEX}}
      if [ ${#NEW_STRING_HEX} -le ${#OLD_STRING_HEX} ] ; then
        # Pad the replacement string with null terminations so the
        # length matches the original string
        while [ ${#NEW_STRING_HEX} -lt ${#OLD_STRING_HEX} ] ; do
          NEW_STRING_HEX="${NEW_STRING_HEX}00"
        done

        # Now, replace every occurrence of OLD_STRING with NEW_STRING 
        #echo "Replacing ${OLD_STRING//@@@@@/ }"
        #echo "with"
        #echo "${NEW_STRING//@@@@@/ }... "
        #echo "Replacing ${OLD_STRING_HEX}"
        #echo "with"
        #echo "${NEW_STRING_HEX}... "
        cp -a ${FILE} ${FILE}.tmp
        hexdump -ve '1/1 "%.2X"' ${FILE} | \
        perl -p -e "s/${OLD_STRING_HEX}/${NEW_STRING_HEX}/g" | \
        xxd -r -p > ${FILE}.tmp
        mv ${FILE}.tmp ${FILE}
      else
        echo "New path"
        echo ${NEW_STRING}
        echo "is longer placeholder"
        echo ${OLD_STRING}
        echo "Please install ESP in directory with a shorter path"
        exit 1
      fi
    done
  fi
}

for input in ${PREFIX}/info/has_prefix*; do
  while read -r pfx typ file
  do
    if [[ "$typ" == "binary" ]]; then
      patch_strings_binary_file $file $pfx $PREFIX
    elif [[ "$typ" == "text" ]]; then
      echo "Patching '$file'"
      perl -pi -e "s/$(echo "${pfx}" | sed 's/\//\\\//g')/$INSTALLPATH/g" $file
    fi
  done < "$input"
done

