import sys
from importlib import metadata as importlib_metadata
from subprocess import call

dists = importlib_metadata.distributions()
for dist in dists:
    if dist.metadata["Name"] is None: continue
    print("Installing", dist.metadata["Name"])
    call(sys.executable + " -m pip install --disable-pip-version-check --no-index --force-reinstall --no-warn-script-location --find-link pip_wheels " + dist.metadata["Name"], shell=True)
	
for dist in ["matplotlib", "f90nml", "virtualenv", "cvxopt", "dill", "packaging", "openmdao", "pynastran"]:
    found = False
    for key in dists:
        if key.metadata["Name"] == dist:
            found = True
            break
    if found: continue
    print("Installing", dist)
    call(sys.executable + " -m pip install --disable-pip-version-check --no-index --no-warn-script-location --find-link pip_wheels " + dist, shell=True)
