@echo off
SETLOCAL ENABLEDELAYEDEXPANSION

SET PythonDir=Python-3.11.9
SET CASRev=7.8
SET OCCmaint=1
SET ESPRev=127

REM Get current folder with no trailing slash
SET ScriptDir=%~dp0
SET ScriptDir=%ScriptDir:~0,-1%
IF "%ScriptDir:~1,1%" == "\" (
  echo UNC Drive Found!
  set Drive=
  for %%i in (c: d: e: f: g: h: i: j: k: l: m: n: o: p: q: r: s: t: u: v: w: x: y: z:) do (
     for /f "skip=1 tokens=1,2*" %%a IN ('net use %%i') do if not defined Drive (
        echo %scriptDir% | findstr /C:"%%c" && (
           echo Drive Found %%i
           set Drive=%%i
           set PreFix=%%c
        )
     )
  )
  if not defined Drive (
    echo WARNING: Drive Letter NOT Found UNC path %ScriptDir%
    pause
  ) else (
    rem set ScriptDir=!Drive!%~p0
    echo PreFix is !PreFix!
    call set ScriptDir=%%ScriptDir:!Prefix!=!Drive!%%
  )
)
SET NOSPACE=%ScriptDir: =-%
if %NOSPACE% == %ScriptDir% (
  echo.
) else (
  echo.
  echo ERROR: Current path is "%ScriptDir%"
  echo.
  echo Please start over and unpack ESP in a path without spaces
  echo.
  pause
  GOTO:EOF
)

SET START="C:\Program Files\Internet Explorer\iexplore.exe"
if exist "C:\Program Files (x86)\Microsoft\Edge\Application\msedge.exe" (
  echo Microsoft Edge!
  SET START="C:\Program Files (x86)\Microsoft\Edge\Application\msedge.exe"
) else (
  if exist "C:\Program Files\Mozilla Firefox\firefox.exe" (
    echo Found 64bit FireFox!
    SET START="C:\Program Files\Mozilla Firefox\firefox.exe"
  ) else (
    if exist "C:\Program Files (x86)\Mozilla Firefox\firefox.exe" (
      echo Found FireFox!
      SET START="C:\Program Files (x86)\Mozilla Firefox\firefox.exe"
    ) else (
      if exist "C:\Program Files\Google\Chrome\Application\chrome.exe" (
        echo Found 64bit Chrome!
        SET START="C:\Program Files\Google\Chrome\Application\chrome.exe"
      ) else (
        if exist "C:\Program Files (x86)\Google\Chrome\Application\chrome.exe" (
          echo Found Chrome!
          SET START="C:\Program Files (x86)\Google\Chrome\Application\chrome.exe"
        ) else (
          echo WARNING: Using Internet Explorer
        )
      )
    )
  )
)

SET ESP_ROOT=%ScriptDir%\EngSketchPad
if defined PYTHONPATH (
  SET PPATH=%ESP_ROOT%\lib;%ESP_ROOT%\pyESP;%ScriptDir%\%PythonDir%\Lib\site-packages;%%PYTHONPATH%%
) else (
  SET PPATH=%ESP_ROOT%\lib;%ESP_ROOT%\pyESP;%ScriptDir%\%PythonDir%\Lib\site-packages
)
SET PYTHONPATH=%PPATH%
SET PATH=%ScriptDir%\%PythonDir%\Scripts;%%PATH%%

(
  echo rem ESP Environment File
  echo set MSVC=2022
  echo set ESP_ARCH=WIN64
  echo set ESP_ROOT=%ESP_ROOT%
  echo set CASROOT=%ScriptDir%\OpenCASCADE-%CASRev%.%OCCmaint%
  echo set CASARCH=win64\vc14
  echo set CASREV=%CASRev%
  echo set UDUNITS2_XML_PATH=%ESP_ROOT%\src\CAPS\udunits\udunits2.xml
  echo set PATH=%ScriptDir%\%PythonDir%;%ScriptDir%\%PythonDir%\Scripts;%%CASROOT%%\%%CASARCH%%\bin;%ESP_ROOT%\lib;%ESP_ROOT%\bin;%%PATH%%
  echo set PYTHONHOME=%ScriptDir%\%PythonDir%
  echo set PYTHONPATH=%PPATH%
  echo set CAPS_GLYPH=%ESP_ROOT%\src\CAPS\aim\pointwise\glyph
  echo set SLUGS_START=^"start /b %START% %ESP_ROOT%\SLUGS\Slugs.html^"
  echo set ESP_START=^"start /b %START% %ESP_ROOT%\ESP\ESP-localhost7681.html^"
  echo set WV_START=^"start /b %START% %ESP_ROOT%\wvClient\wv.html^"
)>%ScriptDir%\EngSketchPad\ESPenv.bat

(
  echo rem ESP Environment File
  echo set MSVC=2022
  echo set ESP_ARCH=WIN64
  echo set ESP_ROOT=%ESP_ROOT%
  echo set CASROOT=%ScriptDir%\OpenCASCADE-%CASRev%.%OCCmaint%
  echo set CASARCH=win64\vc14
  echo set CASREV=%CASRev%
  echo set UDUNITS2_XML_PATH=%ESP_ROOT%\src\CAPS\udunits\udunits2.xml
  echo set PATH=%ScriptDir%\%PythonDir%;%ScriptDir%\%PythonDir%\Scripts;%%CASROOT%%\%%CASARCH%%\bin;%ESP_ROOT%\lib;%ESP_ROOT%\bin;%%PATH%%
  echo set PYTHONHOME=%ScriptDir%\%PythonDir%
  echo set PYTHONPATH=%PPATH%
  echo set CAPS_GLYPH=%ESP_ROOT%\src\CAPS\aim\pointwise\glyph
  echo set SLUGS_START=^"start /b %START% %ESP_ROOT%\SLUGS\Slugs.html^"
  echo set ESP_START=^"start /b %START% %ESP_ROOT%\ESP\ESP-localhost7681.html^"
  echo set WV_START=^"start /b %START% %ESP_ROOT%\wvClient\wv.html^"
  echo cd %ESP_ROOT%\bin
  echo serveESP
)>%ScriptDir%\EngSketchPad\ESPrun.bat

SET Esc_LinkArgs=%%ESP_ROOT%%\ESPenv
SET Esc_LinkWork=%%ESP_ROOT%%\bin
SET Esc_linkIcon=%%ScriptDir%%\esp_logo.ico
SET cSctVBS=%ScriptDir%\CreateShortcut.vbs
SET LOG="%ScriptDir%\%~N0_runtime.log"
((
  echo Set oWS = WScript.CreateObject^("WScript.Shell"^)
  echo strDesktop = oWS.SpecialFolders^("Desktop"^)
  echo sLinkFile = oWS.ExpandEnvironmentStrings^(strDesktop + "\ESP%ESPRev%.lnk"^)
  echo Set oLink = oWS.CreateShortcut^(sLinkFile^)
  echo oLink.TargetPath = "%%COMSPEC%%"
  echo oLink.IconLocation = oWS.ExpandEnvironmentStrings^("!Esc_LinkIcon!"^)
  echo oLink.Arguments = "/k "+oWS.ExpandEnvironmentStrings^("!Esc_LinkArgs!"^)
  echo oLink.WorkingDirectory = oWS.ExpandEnvironmentStrings^("!Esc_LinkWork!"^)
  echo oLink.Save
)1>!cSctVBS!
%SystemRoot%\System32\cscript.exe //nologo !cSctVBS!
DEL !cSctVBS! /f /q
)1>>!LOG! 2>>&1

SET Esc_LinkArgs=%%ESP_ROOT%%\ESPrun
SET Esc_LinkWork=%%ESP_ROOT%%\bin
SET Esc_linkIcon=%%ScriptDir%%\esp_logo.ico
SET cSctVBS=%ScriptDir%\CreateShortcut.vbs
SET LOG="%ScriptDir%\%~N0_runtime.log"
((
  echo Set oWS = WScript.CreateObject^("WScript.Shell"^)
  echo strDesktop = oWS.SpecialFolders^("Desktop"^)
  echo sLinkFile = oWS.ExpandEnvironmentStrings^(strDesktop + "\runESP%ESPRev%.lnk"^)
  echo Set oLink = oWS.CreateShortcut^(sLinkFile^)
  echo oLink.TargetPath = "%%COMSPEC%%"
  echo oLink.IconLocation = oWS.ExpandEnvironmentStrings^("!Esc_LinkIcon!"^)
  echo oLink.Arguments = "/c "+oWS.ExpandEnvironmentStrings^("!Esc_LinkArgs!"^)
  echo oLink.WorkingDirectory = oWS.ExpandEnvironmentStrings^("!Esc_LinkWork!"^)
  echo oLink.Save
)1>!cSctVBS!
%SystemRoot%\System32\cscript.exe //nologo !cSctVBS!
DEL !cSctVBS! /f /q
)1>>!LOG! 2>>&1

cd %ScriptDir%\%PythonDir%
%ScriptDir%\%PythonDir%\python install.py
