import os
from typing import BinaryIO
from pyNastran.utils import PathLike, print_bad_path
import struct

def read_zona_aic(aic_filename: PathLike):
    """

    ints    = (120, 0, 0,     -858993459,   1.725, 12,  0, 0, 0,       -1717986918, 1068079513, 1202590843, 1068792545, -1717986918, 1069128089, -1030792151, 1069295861, -343597384, 1069463633, 515396076, 1069673349, 1202590843, 1069841121, 1889785610, 1070008893, -1717986918, 1070176665, 0, 1070596096, 0, 1071644672, 120, 40, 2, 0, 24, 0, 24, 0, 3, 0, 1, 0, 40, 400, 1, 0, 24, 0, 2082379753, -1072873161, 0, -2147483648, 1258296997, -1074391348, 0, -2147483648, -1553433972, -1075153468, 0, -2147483648, 1750608434, -1074678049, 0, -2147483648, -1616679278, -1076048964, 0, -2147483648, 1031096171, -1075909504, 0, -2147483648, -1810520654, -1076049531, 0, -2147483648, -1277846992, -1075395023, 0, -2147483648, 2064427345, -1077577938, 0, -2147483648, -47956232, -1077085509, 0, -2147483648, -1300259337, -1076880677, 0, -2147483648, 1334598274, -1076027747, 0, -2147483648, 2090923842, -1078563279, 0, -2147483648, 237517708, -1077919799, 0, -2147483648, -420429030, -1077715640, 0, -2147483648, -1501140878, -1076695415, 0, -2147483648, 421288573, -1079370822, 0, -2147483648, 1212015304, -1078764164, 0, -2147483648, -340882979, -1078477083, 0, -2147483648, 1331319404, -1077385986, 0, -2147483648, -350799027, -1080234263, 0, -2147483648, 1924861436, -1079695141, 0, -2147483648, -997790188, -1079387147, 0, -2147483648, -1482305921, -1078203003, 0, -2147483648, 400, 400, 1, 0, 24, 0, 974038783, 1074139629, 0, 0, -1465271346, -1073362636, 0, -2147483648, -2080568150, -1074943525, 0, -2147483648, 1498913469, -1075021543, 0, -2147483648, 1983228664, -1078545166, 0, -2147483648, 1719267580, -1076786099, 0, -2147483648, -730467956, -1076669906, 0, -2147483648, -2066354892, -1076012751, 0, -2147483648, 719934929, -1078832891, 0, -2147483648, 798086178, -1078079525, 0, -2147483648, -1118306399, -1077802335, 0, -2147483648, 1735988995, -1076868934, 0, -2147483648, -1808747127, -1079697040, 0, -2147483648, 1766063421, -1078964603, 0, -2147483648, -254764112, -1078715838, 0, -2147483648, 50033113, -1077703561, 0, -2147483648, 1360236634, -1080503972, 0, -2147483648, -1624865900, -1079840679, 0, -2147483648, 137106819, -1079538175, 0, -2147483648, 1064660994, -1078461977, 0, -2147483648, -765408363, -1081397133, 0, -2147483648, 251633734, -1080805069, 0, -2147483648, -1703514294, -1080498965, 0, -2147483648, -148374413, -1079342697, 0, -2147483648, 400, 400, 1, 0, 24, 0, -1029674596, 1070835377, 0, 0, -1668176044, 1074182765, 0, 0, 1735845312, -1073359935, 0, -2147483648, 1440941424, -1074314317, 0, -2147483648, 586256631, 1068712884, 0, 0, 1256987193, -1078913370, 0, -2147483648, 2100912796, -1076766629, 0, -2147483648, -1139250172, -1075862715, 0, -2147483648, -1333848933, -1080020183, 0, -2147483648, -1562970933, -1078743994, 0, -2147483648, -171344587, -1078068162, 0, -2147483648, 1164461405, -1077065392, 0, -2147483648, -317572735, -1080256168, 0, -2147483648, -1301346838, -1079474292, 0, -2147483648, 208836281, -1078966608, 0, -2147483648, 470347175, -1077914450, 0, -2147483648, -308961793, -1080925609, 0, -2147483648, -1472841436, -1080212999, 0, -2147483648, -1364020829, -1079853201, 0, -2147483648, -240979112, -1078766779, 0, -2147483648, -853005916, -1081830676, 0, -2147483648, 1510155668, -1081128143, 0, -2147483648, 860807401, -1080848150, 0, -2147483648, -79481312, -1079708802, 0, -2147483648, 400, 400, 1, 0, 24, 0, -316358074, 1069680951, 0, 0, -904163152, 1070837509, 0, 0, 1826317484, 1074137711, 0, 0, 888310715, -1072839800, 0, -2147483648, 637052711, 1068280048, 0, 0, -2143216535, 1068666736, 0, 0, 535007115, -1078435560, 0, -2147483648, -1808129331, -1076018636, 0, -2147483648, -262215429, -1082681761, 0, -2147483648, 971775005, -1079996774, 0, -2147483648, 19315754, -1078816367, 0, -2147483648, -269760388, -1077568252, 0, -2147483648, -285879538, -1081272867, 0, -2147483648, -1243604002, -1080256967, 0, -2147483648, -1307328231, -1079703178, 0, -2147483648, 1949182591, -1078565274, 0, -2147483648, -1923718357, -1081760995, 0, -2147483648, 58251605, -1080940785, 0, -2147483648, -952824959, -1080541097, 0, -2147483648, 1670654859, -1079399182, 0, -2147483648, 2009062390, -1082576938, 0, -2147483648, 877022442, -1081887997, 0, -2147483648, -461945053, -1081528172, 0, -2147483648, 1125688335, -1080336790, 0, -2147483648, 400, 400, 1, 0, 24, 0, -1666397904, -1076007821, 0, -2147483648, 1777949348, -1075640836, 0, -2147483648, 1509260209, -1075663946, 0, -2147483648, 217475071, -1074779694, 0, -2147483648, -856851059, -1073012239, 0, -2147483648, 1126501208, -1074672391, 0, -2147483648, 117233555, -1075558302, 0, -2147483648, 1679423837, -1075156561, 0, -2147483648, -280692429, -1076364763, 0, -2147483648, 1039033610, -1076309431, 0, -2147483648, 330882751, -1076457577, 0)
    floats  = (120, 0.0, 0.0, -107374184.0, 1.725, 1.2, 0.0, 0.0, 0.0, -1.5881868392106856e-23, 1.3249999284744263, 89128.9609375, 1.409999966621399, -1.5881868392106856e-23, 1.4499999284744263, -71.68000030517578, 1.46999990940094, -3.2186439840828266e+26, 1.4899998903274536, 1.9515639880220904e-20, 1.5149999856948853, 89128.9609375, 1.534999966621399, 4.0564818300608976e+29, 1.5549999475479126, -1.5881868392106856e-23, 1.5749999284744263, 0.0, 1.625, 0.0, 1.75, 1.6815581571897805e-43, 5.605193857299268e-44, 2.802596928649634e-45, 0.0, 3.363116314379561e-44, 0.0, 3.363116314379561e-44, 0.0, 4.203895392974451e-45, 0.0, 1.401298464324817e-45, 0.0, 5.605193857299268e-44, 5.605193857299268e-43, 1.401298464324817e-45, 0.0, 3.363116314379561e-44, 0.0, 3.29385603064208e+36, -2.2071053981781006, 0.0, -0.0, 8394405.0, -1.9225707054138184, 0.0, -0.0, -1.2602695511008865e-17, -1.831718921661377, 0.0, -0.0, 4.083238105722564e+24, -1.8883932828903198, 0.0, -0.0, -6.921610843887334e-20, -1.7249674797058105, 0.0, -0.0, 0.05988256260752678, -1.7415924072265625, 0.0, -0.0, -7.555255230739976e-27, -1.7248998880386353, 0.0, -0.0, -9.946631962520769e-08, -1.802923321723938, 0.0, -0.0, 7.303557048990567e+35, -1.5426995754241943, 0.0, -0.0, -1.3645021484471067e+37, -1.601401686668396, 0.0, -0.0, -1.4878870580048442e-08, -1.6258195638656616, 0.0, -0.0, 4709483520.0, -1.7274967432022095, 0.0, -0.0, 6.686259852771203e+36, -1.425237774848938, 0.0, -0.0, 2.0736269539465856e-30, -1.5019465684890747, 0.0, -0.0, -5.684834722402666e+23, -1.5262842178344727, 0.0, -0.0, -9.326427789915293e-16, -1.6479045152664185, 0.0, -0.0, 8.083284935261465e-24, -1.3289711475372314, 0.0, -0.0, 194443.125, -1.4012904167175293, 0.0, -0.0, -4.220082671030778e+26, -1.4355131387710571, 0.0, -0.0, 3662834688.0, -1.565582036972046, 0.0, -0.0, -1.82827838783592e+26, -1.2260409593582153, 0.0, -0.0, 7.409997172300826e+30, -1.2903093099594116, 0.0, -0.0, -1079.43994140625, -1.327025055885315, 0.0, -0.0, -4.602058327924123e-15, -1.4681860208511353, 0.0, -0.0, 5.605193857299268e-43, 5.605193857299268e-43, 1.401298464324817e-45, 0.0, 3.363116314379561e-44, 0.0, 0.0005441754474304616, 2.094844102859497, 0.0, 0.0, -1.884421641624133e-14, -2.0904054641723633, 0.0, -0.0, -1.4872911064059595e-36, -1.8567460775375366, 0.0, -0.0, 3792953533267968.0, -1.8474456071853638, 0.0, -0.0, 9.211654195427032e+32, -1.4273970127105713, 0.0, -0.0, 2.9507865783148238e+23, -1.6370941400527954, 0.0, -0.0, -4225277886464.0, -1.6509454250335693, 0.0, -0.0, -5.029389601177546e-36, -1.729284405708313, 0.0, -0.0, 4.144866145184417e-13, -1.3930975198745728, 0.0, -0.0, 2.6526075780353153e-10, -1.4829057455062866, 0.0, -0.0, -0.052734021097421646, -1.5159493684768677, 0.0, -0.0, 1.1762937455210191e+24, -1.6272194385528564, 0.0, -0.0, -8.92153073333168e-27, -1.2900829315185547, 0.0, -0.0, 1.480852617477545e+25, -1.3773962259292603, 0.0, -0.0, -5.164887734510482e+29, -1.4070513248443604, 0.0, -0.0, 3.6946480607037665e-37, -1.5277241468429565, 0.0, -0.0, 39611375616.0, -1.1938891410827637, 0.0, -0.0, -3.526070618508954e-20, -1.27295982837677, 0.0, -0.0, 5.178465415927407e-34, -1.3090211153030396, 0.0, -0.0, 0.9587403535842896, -1.4373139142990112, 0.0, -0.0, -241372053504.0, -1.0874160528182983, 0.0, -0.0, 6.301669109108494e-30, -1.157995581626892, 0.0, -0.0, -5.096150626077019e-23, -1.1944860219955444, 0.0, -0.0, -3.407163491539553e+33, -1.3323239088058472, 0.0, -0.0, 5.605193857299268e-43, 5.605193857299268e-43, 1.401298464324817e-45, 0.0, 3.363116314379561e-44, 0.0, -80.20626831054688, 1.6535245180130005, 0.0, 0.0, -9.638548412157262e-22, 2.105128526687622, 0.0, 0.0, 1.1659402942368675e+24, -2.0910494327545166, 0.0, -0.0, 31201561673728.0, -1.9317535161972046, 0.0, -0.0, 6.547666839081392e-18, 1.4005036354064941, 0.0, 0.0, 7736604.5, -1.3835036754608154, 0.0, -0.0, 1.5401199273015251e+37, -1.6394151449203491, 0.0, -0.0, -0.009303096681833267, -1.747170090675354, 0.0, -0.0, -9.279774171311317e-10, -1.2515612840652466, 0.0, -0.0, -5.826400086520879e-18, -1.4036948680877686, 0.0, -0.0, -5.108355316692237e+32, -1.4842603206634521, 0.0, -0.0, 3716.335205078125, -1.603799819946289, 0.0, -0.0, -2.828395586931919e+27, -1.2234296798706055, 0.0, -0.0, -1.3912975660446136e-08, -1.316636562347412, 0.0, -0.0, 1.868835831119492e-31, -1.377157211303711, 0.0, -0.0, 4.530578377800625e-22, -1.5025842189788818, 0.0, -0.0, -5.78803400256413e+27, -1.143626093864441, 0.0, -0.0, -1.011541992204136e-14, -1.2285758256912231, 0.0, -0.0, -8.12605746580708e-11, -1.2714670896530151, 0.0, -0.0, -1.613784196271192e+30, -1.400978684425354, 0.0, -0.0, -176331328.0, -1.035733699798584, 0.0, -0.0, 9228634883620864.0, -1.119482159614563, 0.0, -0.0, 4.816766718818144e-08, -1.1528599262237549, 0.0, -0.0, -1.013595672834089e+36, -1.2886807918548584, 0.0, -0.0, 5.605193857299268e-43, 5.605193857299268e-43, 1.401298464324817e-45, 0.0, 3.363116314379561e-44, 0.0, -3.186900236584977e+27, 1.5159062147140503, 0.0, 0.0, -2548780.0, 1.6537786722183228, 0.0, 0.0, 2.1218413118709715e+27, 2.0943868160247803, 0.0, 0.0, 4.517767990819266e-07, -2.215059280395508, 0.0, -0.0, 4.3134409038118437e-16, 1.3489055633544922, 0.0, 0.0, -5.979498894000463e-39, 1.3950023651123047, 0.0, 0.0, 9.63757114349997e-20, -1.4404630661010742, 0.0, -0.0, -9.397463459700743e-27, -1.7285828590393066, 0.0, -0.0, -2.759493131379056e+29, -0.9671382308006287, 0.0, -0.0, 0.0004503437376115471, -1.2543518543243408, 0.0, -0.0, 3.0624385818506135e-38, -1.3950673341751099, 0.0, -0.0, -1.4594269609076579e+29, -1.5438542366027832, 0.0, -0.0, -3.8039488433649494e+28, -1.1022297143936157, 0.0, -0.0, -1.6697410956112435e-06, -1.2233344316482544, 0.0, -0.0, -8.600431478100745e-09, -1.289351224899292, 0.0, -0.0, 5.519540872589433e+31, -1.4249999523162842, 0.0, -0.0, -6.606321039615626e-31, -1.044040322303772, 0.0, -0.0, 7.313013468749267e-37, -1.1418169736862183, 0.0, -0.0, -46347.50390625, -1.189463496208191, 0.0, -0.0, 5.466511448948815e+21, -1.3255903720855713, 0.0, -0.0, 7.782734670401018e+33, -0.9733861684799194, 0.0, -0.0, 1.8468168150320707e-07, -1.0289005041122437, 0.0, -0.0, -1.8245886908028548e+22, -1.0717949867248535, 0.0, -0.0, 152.64085388183594, -1.2138187885284424, 0.0, -0.0, 5.605193857299268e-43, 5.605193857299268e-43, 1.401298464324817e-45, 0.0, 3.363116314379561e-44, 0.0, -1.1434010978569665e-21, -1.7298721075057983, 0.0, -0.0, 3.7681320916691128e+25, -1.7736201286315918, 0.0, -0.0, 8637171179192320.0, -1.7708652019500732, 0.0, -0.0, 3.7964891677744685e-31, -1.8762762546539307, 0.0, -0.0, -124513384.0, -2.1739466190338135, 0.0, -0.0, 165.0443115234375, -1.8890677690505981, 0.0, -0.0, 9.510862229571371e-35, -1.783458948135376, 0.0, -0.0, 1.1361281445463358e+22, -1.8313502073287964, 0.0, -0.0, -6.09603252947583e+28, -1.6873213052749634, 0.0, -0.0, 0.11640365421772003, -1.6939173936843872, 0.0, -0.0, 4.666777470585076e-27, -1.6762570142745972, 0.0)
    """
    assert os.path.exists(aic_filename), print_bad_path(aic_filename)
    with open(aic_filename, "rb") as aic_file:
        data = aic_file.read()
    #show_n(data, 2000, types='ifqd')

def show_n(data: bytes, n: int, types='ifsdq'):
    n = min(n, len(data))
    sfmt = f'{n}s'
    datan = data[:n]

    nints = n // 4
    ndoubles = n // 8
    ifmt = f'{nints}i'
    ffmt = f'{nints}f'
    dfmt = f'{ndoubles}d'
    qfmt = f'{ndoubles}q'
    if 's' in types:
        sdata = struct.unpack(sfmt, datan)
        print(f'strings = {sdata}')
    if 'i' in types:
        idata = struct.unpack(ifmt, datan)
        print(f'ints    = {idata}')
    if 'f' in types:
        fdata = struct.unpack(ffmt, datan)
        print(f'floats  = {fdata}')
    if 'q' in types:
        qdata = struct.unpack(qfmt, datan)
        print(f'long = {qdata}')
    if 'd' in types:
        ddata = struct.unpack(dfmt, datan)
        print(f'doubles = {ddata}')
