#!/bin/bash

ScriptDir="`dirname \"$0\"`"
ScriptDir="`( cd \"$ScriptDir\" && pwd )`"

ESPrev=1.29
OCCrev=7.8
OCCmaint=1
PythonDir=Python-3.12.10

PyVer=${PythonDir%.*}
PyVer=${PyVer#*-}

ESP_ROOT=$ScriptDir/EngSketchPad
DESKTOP=$HOME/Desktop
EPATH=.:'$ESP_ROOT/bin':$ScriptDir/$PythonDir/bin
LDPATH='$CASROOT/lib:$ESP_ROOT/lib'
PPATH='$ESP_ROOT/lib:$ESP_ROOT/pyESP':$ScriptDir/$PythonDir/lib/python$PyVer/site-packages

if [ -z "$PYTHONPATH" ]; then
    export PYTHONPATH=$PPATH
else
    export PYTHONPATH=$PPATH:$PYTHONPATH
fi

#
# determine the machine type
#
mt=UNKNOWN
if [ -f /bin/uname -o -f /usr/bin/uname \
		-o -f /bin/uname.exe -o -f /usr/bin/uname.exe ]; then
	if [ -f /bin/uname ]; then
		mt="`/bin/uname -m`"
	elif [ -f /usr/bin/uname ]; then
		mt="`/usr/bin/uname -m`"
	elif [ -f /bin/uname.exe ]; then
		mt="`/bin/uname.exe -m`"
	else
		mt="`/usr/bin/uname.exe -m`"
	fi
fi
if [ "$mt" = UNKNOWN ]; then
	echo "WARNING - Cannot parse architecture type!"
fi

#
# set our architecture
#
CARCH=LINUX64
if [ "$mt" = aarch64 ]; then
	CARCH=LINUX_AARCH64
fi


cat > $ESP_ROOT/ESPenv.csh <<EOF
# ESP $ESPrev PreBuilt Linux tcsh shell Environment Variables

setenv ESP_ARCH $CARCH
setenv ESP_ROOT $ESP_ROOT
setenv CASROOT  $ScriptDir/OpenCASCADE-$OCCrev.$OCCmaint
setenv CASARCH  .
setenv CASREV   $OCCrev
if ( \$?PATH == 0 ) then
    setenv PATH $EPATH
else
    if ( "\$PATH" == "" ) then
        setenv PATH $EPATH
    else
        setenv PATH $EPATH:\$PATH
    endif
endif
if ( \$?LD_LIBRARY_PATH == 0 ) then
    setenv LD_LIBRARY_PATH $LDPATH
else
    if ( "\$LD_LIBRARY_PATH" == "" ) then
        setenv LD_LIBRARY_PATH $LDPATH
    else
        setenv LD_LIBRARY_PATH $LDPATH:\$LD_LIBRARY_PATH
    endif
endif
setenv PYTHONINC  $ScriptDir/$PythonDir/include/python${PyVer}
setenv PYTHONLIB "-L$ScriptDir/$PythonDir/lib -lpython${PyVer}"
if ( \$?PYTHONPATH == 0 ) then
    setenv PYTHONPATH $PPATH
else
    if ( "\$PYTHONPATH" == "" ) then
        setenv PYTHONPATH $PPATH
    else
        setenv PYTHONPATH $PPATH:\$PYTHONPATH
    endif
endif
setenv UDUNITS2_XML_PATH \$ESP_ROOT/src/CAPS/udunits/udunits2.xml
setenv CAPS_GLYPH \$ESP_ROOT/src/CAPS/aim/pointwise/glyph
setenv SLUGS_START "firefox \$ESP_ROOT/SLUGS/Slugs.html &"
setenv ESP_START "firefox \$ESP_ROOT/ESP/ESP-localhost7681.html &"
setenv WV_START "firefox \$ESP_ROOT/wvClient/wv.html &"
EOF

cat > $ESP_ROOT/ESPenv.sh <<EOF
# ESP $ESPrev PreBuilt Linux bash shell Environment Variables

export ESP_ARCH=$CARCH
export ESP_ROOT=$ESP_ROOT
export CASROOT=$ScriptDir/OpenCASCADE-$OCCrev.$OCCmaint
export CASARCH=.
export CASREV=$OCCrev
if [ -z "\$PATH" ]; then
    export PATH=$EPATH
else
    export PATH=$EPATH:\$PATH
fi
if [ -z "\$LD_LIBRARY_PATH" ]; then
    export LD_LIBRARY_PATH=$LDPATH
else
    export LD_LIBRARY_PATH=$LDPATH:\$LD_LIBRARY_PATH
fi
export PYTHONINC=$ScriptDir/$PythonDir/include/python${PyVer}
export PYTHONLIB="-L$ScriptDir/$PythonDir/lib -lpython${PyVer}"
if [ -z "\$PYTHONPATH" ]; then
    export PYTHONPATH=$PPATH
else
    export PYTHONPATH=$PPATH:\$PYTHONPATH
fi
export UDUNITS2_XML_PATH=\$ESP_ROOT/src/CAPS/udunits/udunits2.xml
export CAPS_GLYPH=\$ESP_ROOT/src/CAPS/aim/pointwise/glyph
export SLUGS_START="firefox \$ESP_ROOT/SLUGS/Slugs.html &"
export ESP_START="firefox \$ESP_ROOT/ESP/ESP-localhost7681.html &"
export WV_START="firefox \$ESP_ROOT/wvClient/wv.html &"
EOF

shelx=`getent passwd $LOGNAME | cut -d: -f7`
shell="bash"
case "$shelx" in
  *tcsh) shell="tcsh";;
   *csh) shell="tcsh";;
esac

cat > $ScriptDir/initfile <<EOF
command -v conda && conda deactivate
command -v deactivate && deactivate
EOF

cat > $DESKTOP/ESP${ESPrev//[.]/}b.desktop <<EOF
[Desktop Entry]
Name=ESP $ESPrev
Exec=bash -c "source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin; exec bash --init-file $ScriptDir/initfile"
Path=$ESP_ROOT/bin
Icon=$ESP_ROOT/ESP/esp_logo.png
Terminal=true
Type=Application
EOF

cat > $DESKTOP/ESP${ESPrev//[.]/}r.desktop <<EOF
[Desktop Entry]
Name=Run ESP $ESPrev
Exec=bash -c "source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin; serveESP"
Path=$ESP_ROOT/bin
Icon=$ESP_ROOT/ESP/esp_logo.png
Terminal=true
Type=Application
EOF

chmod a+x $DESKTOP/ESP${ESPrev//[.]/}b.desktop
chmod a+x $DESKTOP/ESP${ESPrev//[.]/}r.desktop

cd $ScriptDir/$PythonDir
./install.sh
