#!/bin/bash

ScriptDir="`dirname \"$0\"`"
ScriptDir="`( cd \"$ScriptDir\" && pwd )`"

ESPrev=1.29
OCCrev=7.8
OCCmaint=1
PythonDir=Python-3.12.10

PyVer=${PythonDir%.*}
PyVer=${PyVer#*-}

ESP_ROOT=$ScriptDir/EngSketchPad
DESKTOP=$HOME/Desktop
EPATH=.:'$ESP_ROOT/bin':$ScriptDir/$PythonDir/bin
PPATH='$ESP_ROOT/lib:$ESP_ROOT/pyESP':$ScriptDir/$PythonDir/lib/python$PyVer/site-packages

DEACTIVATE="command -v conda && conda deactivate; command -v deactivate && deactivate;"

# Try to remove quaranteen from the download
xattr -r -d com.apple.quarantine $ScriptDir || true

#
# determine the machine type
#
mt=UNKNOWN
if [ -f /bin/uname -o -f /usr/bin/uname \
		-o -f /bin/uname.exe -o -f /usr/bin/uname.exe ]; then
	if [ -f /bin/uname ]; then
		mt="`/bin/uname -m`"
	elif [ -f /usr/bin/uname ]; then
		mt="`/usr/bin/uname -m`"
	elif [ -f /bin/uname.exe ]; then
		mt="`/bin/uname.exe -m`"
	else
		mt="`/usr/bin/uname.exe -m`"
	fi
fi
if [ "$mt" = UNKNOWN ]; then
	echo "WARNING - Cannot parse architecture type!"
fi

#
# set our architecture
#
CARCH=DARWIN64
if [ "$mt" = arm64 ]; then
	CARCH=DARWIN_ARM64
fi


cat > $ESP_ROOT/ESPenv.csh <<EOF
# ESP $ESPrev PreBuilt macOS tcsh shell Environment Variables

setenv ESP_ARCH $CARCH
setenv ESP_ROOT $ESP_ROOT
setenv CASROOT  $ScriptDir/OpenCASCADE-$OCCrev.$OCCmaint
setenv CASARCH  .
setenv CASREV   $OCCrev
if ( \$?PATH == 0 ) then
    setenv PATH $EPATH
else
    if ( "\$PATH" == "" ) then
        setenv PATH $EPATH
    else
        setenv PATH $EPATH:\$PATH
    endif
endif
setenv PYTHONINC $ScriptDir/$PythonDir/include/python$PyVer
setenv PYTHONLIB "-L$ScriptDir/$PythonDir/lib -lpython$PyVer"
if ( \$?PYTHONPATH == 0 ) then
    setenv PYTHONPATH $PPATH
else
    if ( "\$PYTHONPATH" == "" ) then
        setenv PYTHONPATH $PPATH
    else
        setenv PYTHONPATH $PPATH:\$PYTHONPATH
    endif
endif
setenv UDUNITS2_XML_PATH \$ESP_ROOT/src/CAPS/udunits/udunits2.xml
setenv CAPS_GLYPH \$ESP_ROOT/src/CAPS/aim/pointwise/glyph
setenv SLUGS_START "open -a /Applications/Safari.app \$ESP_ROOT/SLUGS/Slugs.html"
setenv ESP_START "open -a /Applications/Safari.app;sleep 1;open -a /Applications/Safari.app \$ESP_ROOT/ESP/ESP-localhost7681.html"
setenv WV_START "open -a /Applications/Safari.app \$ESP_ROOT/wvClient/wv.html"
EOF

cat > $ESP_ROOT/ESPenv.sh <<EOF
# ESP $ESPrev PreBuilt macOS bash shell Environment Variables

export ESP_ARCH=$CARCH
export ESP_ROOT=$ESP_ROOT
export CASROOT=$ScriptDir/OpenCASCADE-$OCCrev.$OCCmaint
export CASARCH=.
export CASREV=$OCCrev
if [ -z "\$PATH" ]; then
    export PATH=$EPATH
else
    export PATH=$EPATH:\$PATH
fi
export PYTHONINC=$ScriptDir/$PythonDir/include/python$PyVer
export PYTHONLIB="-L$ScriptDir/$PythonDir/lib -lpython$PyVer"
if [ -z "\$PYTHONPATH" ]; then
    export PYTHONPATH=$PPATH
else
    export PYTHONPATH=$PPATH:\$PYTHONPATH
fi
export UDUNITS2_XML_PATH=\$ESP_ROOT/src/CAPS/udunits/udunits2.xml
export CAPS_GLYPH=\$ESP_ROOT/src/CAPS/aim/pointwise/glyph
export SLUGS_START="open -a /Applications/Safari.app \$ESP_ROOT/SLUGS/Slugs.html"
export ESP_START="open -a /Applications/Safari.app;sleep 1;open -a /Applications/Safari.app \$ESP_ROOT/ESP/ESP-localhost7681.html"
export WV_START="open -a /Applications/Safari.app \$ESP_ROOT/wvClient/wv.html"
EOF

cat > $DESKTOP/ESP${ESPrev//[.]/}.command <<EOF
#!/usr/bin/osascript

tell app "Terminal"
  do script "cd Desktop; echo \$0 > shell.out; exit"
end tell
set theFile to ((path to Desktop Folder) & "shell.out") as string
set Shell to ""
repeat while Shell = ""
try
  set Shell to (read file theFile)
on error
  delay 0.5
end try
end repeat


tell app "Terminal"
  do script "cd Desktop; /bin/rm shell.out; exit"
end tell
delay 0.5

if "bash" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin"
  end tell
end if

if "zsh" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin"
  end tell
end if

if "csh" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.csh; cd $ESP_ROOT/bin"
  end tell
end if

tell app "Terminal"
  set frontIndex to index of the first window whose frontmost is true
  tell window frontIndex
      set title displays custom title of selected tab to true
      set custom title of selected tab to "ESP $ESPrev"
  end tell
end tell
EOF

export ESP_PYTHON=$ScriptDir/$PythonDir  # Export for FileIcon

chmod a+x $DESKTOP/ESP${ESPrev//[.]/}.command
$ScriptDir/FileIcon set $DESKTOP/ESP${ESPrev//[.]/}.command $ESP_ROOT/ESP/esp_logo.png 

cat > $DESKTOP/runESP${ESPrev//[.]/}.command <<EOF
#!/usr/bin/osascript

tell app "Terminal"
  do script "cd Desktop; echo \$0 > shell.out; exit"
end tell
set theFile to ((path to Desktop Folder) & "shell.out") as string
set Shell to ""
repeat while Shell = ""
try
  set Shell to (read file theFile)
on error
  delay 0.5
end try
end repeat

tell app "Terminal"
  do script "cd Desktop; /bin/rm shell.out; exit"
end tell

if "bash" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin; serveESP; exit"
  end tell
end if

if "zsh" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.sh; cd $ESP_ROOT/bin; serveESP; exit"
  end tell
end if

if "csh" is in Shell then
  tell app "Terminal"
    do script "$DEACTIVATE source $ESP_ROOT/ESPenv.csh; cd $ESP_ROOT/bin; serveESP; exit"
  end tell
end if

tell app "Terminal"
  set frontIndex to index of the first window whose frontmost is true
  tell window frontIndex
      set title displays custom title of selected tab to true
      set custom title of selected tab to "run ESP $ESPrev"
  end tell
end tell
EOF

chmod a+x $DESKTOP/runESP${ESPrev//[.]/}.command
$ScriptDir/FileIcon set $DESKTOP/runESP${ESPrev//[.]/}.command $ESP_ROOT/ESP/esp_logo.png 

cat > $ScriptDir/exthide.command <<EOF
#!/usr/bin/osascript
tell application "Finder"
    set extension hidden of (POSIX file "$DESKTOP/ESP${ESPrev//[.]/}.command" as alias) to true
    set extension hidden of (POSIX file "$DESKTOP/runESP${ESPrev//[.]/}.command" as alias) to true
end tell
EOF
chmod a+x $ScriptDir/exthide.command
osascript $ScriptDir/exthide.command

cd $ScriptDir/$PythonDir
./install.sh
