// This software has been cleared for public release on 05 Nov 2020, case number 88ABW-2020-3462.

#ifndef _AIM_UTILS_JSON_UTILS_H_
#define _AIM_UTILS_JSON_UTILS_H_

#ifdef __cplusplus
extern "C" {
#endif

// JSON

// Whether the string value represents a JSON string
int json_isDict(const char *string);

// Search for all json Key-Value pairs in stringToSearch
int json_dictTuple(void *aimInfo, const char *jsonDict, int *numTuple, capsTuple **tuple);

// Convert a string in tuple form to an array of strings - tuple is assumed to be bounded by '(' and ')' and comma separated
//  for example ["3.0", "hey", "foo"] - note the strings should NOT contain commas. If the
//  string coming in is not a tuple the string is simply copied. Also quotations are removed
int json_parseTuple(/*@null@*/ const char *stringToParse, int *arraySize,
                    char **stringArray[]);

// Search for a Key-Value pair in stringToSearch
int json_keyValue(const char *stringToSearch, char **keyWord, char **keyValue);

// Simple json dictionary parser - currently doesn't support nested arrays for keyValue
int search_jsonDictionary(const char *stringToSearch, const char *keyWord,
                          char **keyValue);

// Get raw string `value` with given `key` in `jsonDict` string
int json_get(const char *jsonDict, const char *key, char **value);

// Get string `value` with given `key` in `jsonDict` string
int json_getString(const char *jsonDict, const char *key, char **value);

// Get array of strings `value` with given `key` in `jsonDict` string
int json_getStringArray(const char *jsonDict, const char *key, int size, char *value[]);

// Get dynamic array of strings `value` with given `key` in `jsonDict` string
int json_getStringDynamicArray(const char *jsonDict, const char *key,
                               int *size, char **value[]);

// Get integer `value` with given `key` in `jsonDict` string
int json_getInteger(const char *jsonDict, const char *key, int *value);

// Get array of integers `value` with given `key` in `jsonDict` string
int json_getIntegerArray(const char *jsonDict, const char *key, int size, int value[]);

// Get dynamic array of integers `value` with given `key` in `jsonDict` string
int json_getIntegerDynamicArray(const char *jsonDict, const char *key,
                                int *size, int *value[]);

// Get double `value` with given `key` in `jsonDict` string
int json_getDouble(const char *jsonDict, const char *key, double *value);

// Get array of doubles `value` with given `key` in `jsonDict` string
int json_getDoubleArray(const char *jsonDict, const char *key, int size, double value[]);

// Get dynamic array of doubles `value` with given `key` in `jsonDict` string
int json_getDoubleDynamicArray(const char *jsonDict, const char *key,
                               int *size, double *value[]);

#ifdef __cplusplus
}
#endif

#endif // _AIM_UTILS_JSON_UTILS_H_
