import numpy as np
from corsairlite import units, Q_

class StandardAtmosphereClass():
    def __init__(self):
        self.SI = np.asarray(
                    #Alt        Temp        Press       Dens                a       Visc (mu)
                [[  -1000.   ,   294.65  ,   113929  ,   1.347       ,   344.111 ,   1.84E-05    ],
                [     0.     ,   288.15  ,   101325  ,   1.225       ,   340.294 ,   1.81E-05    ],
                [   1000.    ,   281.65  ,   89874.6 ,   1.11164     ,   336.434 ,   1.78E-05    ],
                [   2000.    ,   275.15  ,   79495.2 ,   1.00649     ,   332.529 ,   1.75E-05    ],
                [   3000.    ,   268.65  ,   70108.5 ,   0.909122    ,   328.578 ,   1.71E-05    ],
                [   4000.    ,   262.15  ,   61640.2 ,   0.819129    ,   324.579 ,   1.68E-05    ],
                [   5000.    ,   255.65  ,   54019.9 ,   0.736116    ,   320.529 ,   1.65E-05    ],
                [   6000.    ,   249.15  ,   47181.0 ,   0.659697    ,   316.428 ,   1.61E-05    ],
                [   7000.    ,   242.65  ,   41060.7 ,   0.589501    ,   312.274 ,   1.58E-05    ],
                [   8000.    ,   236.15  ,   35599.8 ,   0.525168    ,   308.063 ,   1.54E-05    ],
                [   9000.    ,   229.65  ,   30742.5 ,   0.466348    ,   303.793 ,   1.50E-05    ],
                [   10000.   ,   223.15  ,   26436.3 ,   0.412707    ,   299.463 ,   1.47E-05    ],
                [   11000.   ,   216.65  ,   22632.1 ,   0.363918    ,   295.07  ,   1.43E-05    ],
                [   12000.   ,   216.65  ,   19330.4 ,   0.310828    ,   295.07  ,   1.43E-05    ],
                [   13000.   ,   216.65  ,   16510.4 ,   0.265483    ,   295.07  ,   1.43E-05    ],
                [   14000.   ,   216.65  ,   14101.8 ,   0.226753    ,   295.07  ,   1.43E-05    ],
                [   15000.   ,   216.65  ,   12044.6 ,   0.193674    ,   295.07  ,   1.43E-05    ],
                [   16000.   ,   216.65  ,   10287.5 ,   0.16542     ,   295.07  ,   1.43E-05    ],
                [   17000.   ,   216.65  ,   8786.68 ,   0.141288    ,   295.07  ,   1.43E-05    ],
                [   18000.   ,   216.65  ,   7504.84 ,   0.120676    ,   295.07  ,   1.43E-05    ],
                [   19000.   ,   216.65  ,   6410.01 ,   0.103071    ,   295.07  ,   1.43E-05    ],
                [   20000.   ,   216.65  ,   5474.89 ,   0.0880349   ,   295.07  ,   1.43E-05    ],
                [   21000.   ,   217.65  ,   4677.89 ,   0.0748737   ,   295.75  ,   1.44E-05    ],
                [   22000.   ,   218.65  ,   3999.79 ,   0.0637273   ,   296.428 ,   1.44E-05    ],
                [   23000.   ,   219.65  ,   3422.43 ,   0.0542803   ,   297.105 ,   1.45E-05    ],
                [   24000.   ,   220.65  ,   2930.49 ,   0.0462674   ,   297.781 ,   1.45E-05    ],
                [   25000.   ,   221.65  ,   2511.02 ,   0.0394658   ,   298.455 ,   1.46E-05    ],
                [   26000.   ,   222.65  ,   2153.09 ,   0.0336882   ,   299.128 ,   1.47E-05    ],
                [   27000.   ,   223.65  ,   1847.46 ,   0.0287769   ,   299.799 ,   1.47E-05    ],
                [   28000.   ,   224.65  ,   1586.29 ,   0.0245988   ,   300.468 ,   1.48E-05    ],
                [   29000.   ,   225.65  ,   1362.96 ,   0.021042    ,   301.136 ,   1.48E-05    ],
                [   30000.   ,   226.65  ,   1171.87 ,   0.0180119   ,   301.803 ,   1.49E-05    ],
                [   31000.   ,   227.65  ,   1008.23 ,   0.0154288   ,   302.468 ,   1.49E-05    ],
                [   32000.   ,   228.65  ,   868.019 ,   0.013225    ,   303.131 ,   1.50E-05    ],
                [   33000.   ,   231.45  ,   748.228 ,   0.011262    ,   304.982 ,   1.51E-05    ],
                [   34000.   ,   234.25  ,   646.122 ,   0.00960889  ,   306.821 ,   1.53E-05    ],
                [   35000.   ,   237.05  ,   558.924 ,   0.00821392  ,   308.649 ,   1.55E-05    ],
                [   36000.   ,   239.85  ,   484.317 ,   0.00703441  ,   310.467 ,   1.56E-05    ],
                [   37000.   ,   242.65  ,   420.367 ,   0.00603513  ,   312.274 ,   1.58E-05    ],
                [   38000.   ,   245.45  ,   365.455 ,   0.00518691  ,   314.07  ,   1.59E-05    ],
                [   39000.   ,   248.25  ,   318.22  ,   0.00446557  ,   315.856 ,   1.61E-05    ],
                [   40000.   ,   251.05  ,   277.522 ,   0.00385101  ,   317.633 ,   1.62E-05    ],
                [   41000.   ,   253.85  ,   242.395 ,   0.00332648  ,   319.399 ,   1.64E-05    ],
                [   42000.   ,   256.65  ,   212.03  ,   0.00287802  ,   321.156 ,   1.65E-05    ],
                [   43000.   ,   259.45  ,   185.738 ,   0.00249393  ,   322.903 ,   1.67E-05    ],
                [   44000.   ,   262.25  ,   162.937 ,   0.00216443  ,   324.641 ,   1.68E-05    ],
                [   45000.   ,   265.05  ,   143.135 ,   0.00188129  ,   326.369 ,   1.69E-05    ],
                [   46000.   ,   267.85  ,   125.91  ,   0.0016376   ,   328.088 ,   1.71E-05    ],
                [   47000.   ,   270.65  ,   110.906 ,   0.00142753  ,   329.799 ,   1.72E-05    ],
                [   48000.   ,   270.65  ,   97.7545 ,   0.00125825  ,   329.799 ,   1.72E-05    ],
                [   49000.   ,   270.65  ,   86.1623 ,   0.00110904  ,   329.799 ,   1.72E-05    ],
                [   50000.   ,   270.65  ,   75.9448 ,   0.000977525 ,   329.799 ,   1.72E-05    ],
                [   51000.   ,   270.65  ,   66.9389 ,   0.000861606 ,   329.799 ,   1.72E-05    ],
                [   52000.   ,   267.85  ,   58.9622 ,   0.000766867 ,   328.088 ,   1.71E-05    ],
                [   53000.   ,   265.05  ,   51.8668 ,   0.00068171  ,   326.369 ,   1.69E-05    ],
                [   54000.   ,   262.25  ,   45.5632 ,   0.000605252 ,   324.641 ,   1.68E-05    ],
                [   55000.   ,   259.45  ,   39.97   ,   0.000536684 ,   322.903 ,   1.67E-05    ],
                [   56000.   ,   256.65  ,   35.0137 ,   0.000475263 ,   321.156 ,   1.65E-05    ],
                [   57000.   ,   253.85  ,   30.6274 ,   0.000420311 ,   319.399 ,   1.64E-05    ],
                [   58000.   ,   251.05  ,   26.7509 ,   0.000371207 ,   317.633 ,   1.62E-05    ],
                [   59000.   ,   248.25  ,   23.3296 ,   0.000327382 ,   315.856 ,   1.61E-05    ],
                [   60000.   ,   245.45  ,   20.3143 ,   0.000288321 ,   314.07  ,   1.59E-05    ],
                [   61000.   ,   242.65  ,   17.6606 ,   0.00025355  ,   312.274 ,   1.58E-05    ],
                [   62000.   ,   239.85  ,   15.3287 ,   0.00022264  ,   310.467 ,   1.56E-05    ],
                [   63000.   ,   237.05  ,   13.2826 ,   0.0001952   ,   308.649 ,   1.55E-05    ],
                [   64000.   ,   234.25  ,   11.49   ,   0.000170875 ,   306.821 ,   1.53E-05    ],
                [   65000.   ,   231.45  ,   9.92203 ,   0.000149342 ,   304.982 ,   1.51E-05    ]])

        self.SI = self.SI.T

    # def alt(self, T='n', P='n', rho='n', a='n', nu='n'):
    #     # Currently only works for density
    #     if T !='n':
    #         idx0=1
    #         val=T
    #     elif P !='n':
    #         idx0=2
    #         val=P
    #     elif rho !='n':
    #         idx0=3
    #         val=rho
    #     elif a !='n':
    #         idx0=4
    #         val=a
    #     elif nu !='n':
    #         idx0=5
    #         val=nu

    #     idx2 = np.where( val > self.SI[idx0])[0][0]
    #     idx1 = idx2-1
    #     w1 = (self.SI[idx0][idx2]-val)/(self.SI[idx0][idx2]-self.SI[idx0][idx1])
    #     w2 = (val-self.SI[idx0][idx1])/(self.SI[idx0][idx2]-self.SI[idx0][idx1])
    #     return w1*self.SI[0][idx1]+w2*self.SI[0][idx2]

    def T(self, alt=0):
        alt = alt.to('meter').magnitude
        if alt<self.SI[0].max() and alt>self.SI[0].min():
            idx2 = np.where(alt < self.SI[0])[0][0]
            idx1 = idx2-1
            w1 = (self.SI[0][idx2]-alt)/(self.SI[0][idx2]-self.SI[0][idx1])
            w2 = (alt-self.SI[0][idx1])/(self.SI[0][idx2]-self.SI[0][idx1])
            return (w1*self.SI[1][idx1]+w2*self.SI[1][idx2]) * units.kelvin
        else:
            print("Error: Altitude is out of range")

    def p(self, alt=0):
        alt = alt.to('meter').magnitude
        if alt<self.SI[0].max() and alt>self.SI[0].min():
            idx2 = np.where(alt < self.SI[0])[0][0]
            idx1 = idx2-1
            w1 = (self.SI[0][idx2]-alt)/(self.SI[0][idx2]-self.SI[0][idx1])
            w2 = (alt-self.SI[0][idx1])/(self.SI[0][idx2]-self.SI[0][idx1])
            return (w1*self.SI[2][idx1]+w2*self.SI[2][idx2])*units.pascal
        else:
            print("Error: Altitude is out of range")

    def rho(self, alt=0):
        alt = alt.to('meter').magnitude
        if alt<self.SI[0].max() and alt>self.SI[0].min():
            idx2 = np.where(alt < self.SI[0])[0][0]
            idx1 = idx2-1
            w1 = (self.SI[0][idx2]-alt)/(self.SI[0][idx2]-self.SI[0][idx1])
            w2 = (alt-self.SI[0][idx1])/(self.SI[0][idx2]-self.SI[0][idx1])
            return (w1*self.SI[3][idx1]+w2*self.SI[3][idx2])*units.kilogram/units.meter**3
        else:
            print("Error: Altitude is out of range")

    def a(self, alt=0):
        alt = alt.to('meter').magnitude
        if alt<self.SI[0].max() and alt>self.SI[0].min():
            idx2 = np.where(alt < self.SI[0])[0][0]
            idx1 = idx2-1
            w1 = (self.SI[0][idx2]-alt)/(self.SI[0][idx2]-self.SI[0][idx1])
            w2 = (alt-self.SI[0][idx1])/(self.SI[0][idx2]-self.SI[0][idx1])
            return (w1*self.SI[4][idx1]+w2*self.SI[4][idx2])*units.meter/units.second
        else:
            print("Error: Altitude is out of range")

    def mu(self, alt=0):
        alt = alt.to('meter').magnitude
        if alt<self.SI[0].max() and alt>self.SI[0].min():
            idx2 = np.where(alt < self.SI[0])[0][0]
            idx1 = idx2-1
            w1 = (self.SI[0][idx2]-alt)/(self.SI[0][idx2]-self.SI[0][idx1])
            w2 = (alt-self.SI[0][idx1])/(self.SI[0][idx2]-self.SI[0][idx1])
            return (w1*self.SI[5][idx1]+w2*self.SI[5][idx2])*units.kg/(units.m * units.second)
        else:
            print("Error: Altitude is out of range")
    
    def nu(self, alt=0):
        rho = self.rho(alt)
        mu  = self.mu(alt)
        nu  = mu/rho
        return nu

StandardAtmosphere = StandardAtmosphereClass()
atm = StandardAtmosphereClass()