#ifndef EGADSERRORS_H
#define EGADSERRORS_H
/*
 *      EGADS: Electronic Geometry Aircraft Design System
 *
 *             Error Code Header
 *
 *      Copyright 2011-2025, Massachusetts Institute of Technology
 *      Licensed under The GNU Lesser General Public License, version 2.1
 *      See http://www.opensource.org/licenses/lgpl-2.1.php
 *
 */

#define EGADS_EXTRAPOL -37
#define EGADS_EFFCTOBJ -36
#define EGADS_UVMAP    -35
#define EGADS_SEQUERR  -34
#define EGADS_CNTXTHRD -33
#define EGADS_READERR  -32
#define EGADS_TESSTATE -31
#define EGADS_EXISTS   -30
#define EGADS_ATTRERR  -29
#define EGADS_TOPOCNT  -28
#define EGADS_OCSEGFLT -27           /* obsolete */
#define EGADS_BADSCALE -26
#define EGADS_NOTORTHO -25
#define EGADS_DEGEN    -24
#define EGADS_CONSTERR -23
#define EGADS_TOPOERR  -22
#define EGADS_GEOMERR  -21
#define EGADS_NOTBODY  -20
#define EGADS_WRITERR  -19
#define EGADS_NOTMODEL -18
#define EGADS_NOLOAD   -17
#define EGADS_RANGERR  -16
#define EGADS_NOTGEOM  -15
#define EGADS_NOTTESS  -14
#define EGADS_EMPTY    -13
#define EGADS_NOTTOPO  -12
#define EGADS_REFERCE  -11
#define EGADS_NOTXFORM -10
#define EGADS_NOTCNTX   -9
#define EGADS_MIXCNTX   -8
#define EGADS_NODATA    -7
#define EGADS_NONAME    -6
#define EGADS_INDEXERR  -5
#define EGADS_MALLOC    -4
#define EGADS_NOTOBJ    -3
#define EGADS_NULLOBJ   -2
#define EGADS_NOTFOUND  -1
#define EGADS_SUCCESS    0
#define EGADS_OUTSIDE    1      /* also -- not the same */

#endif
