#ifndef MATECONTOURS_H
#define MATECONTOURS_H

#include "egads.h"

#ifdef __ProtoExt__
#undef __ProtoExt__
#endif
#ifdef __cplusplus
extern "C" {
#define __ProtoExt__
#else
#define __ProtoExt__ extern
#endif

__ProtoExt__ int
EG_mateContours( ego body, const char *aName1, const char *aName2, ego *newBody,
                 int *ncontour, int **nent, int **contour1, int **contour2 );


/*
icode = EG_mateContours(ego body, char *attrName1, char *attrName2, ego newBody,
                        int *ncontour, int **nent, int **contr1, int **contr2)

body            input Sheet or Solid Body
attrName1       the attribute name for the first side(s)
attrName2       the attribute name for the second side(s)
newBody         resultant new Body with Nodes inserted in the appropriate places
ncontour        the returned number of sets of contours found
nent            a pointer to the returned number of Edges (and/or Nodes) 
                found in each contour (ncontour in length -- freeable)
contr1          the returned list of Edges/Nodes indices and senses that 
                represents a Face crossing contour built from the Edges with 
                attrName1 (sum of 2*nent in length -- freeable)
contr2          the returned list of Edges/Nodes indices and senses that 
                represents a Face crossing contour built from the Edges with 
                attrName2 (sum of 2*nent in length -- freeable)

Signature notes:
1) All attributed sets of Edges must be closed
2) contr1 & contr2 refer to Edge/Node indices and senses in newBody
3) contr1 & contr2 contain the complete suite of contours, where the number
   of the first set is nent[0] and if ncontour is greater than 1, the second
   set begins at contr1[nent[0]] and contr2[nent[0]], and so forth...
4) In general the entities in contr1 and contr2 are Edge indices with senses. 
   If the sense is 0 then it refers to a Node index in the Body. A Node found 
   in either list means that the corresponding Edge in the other list creates a
   fan (3 sided, vs. a 4 sided surface). You will not see a Node associated 
   with another Node.
5) The Faces to be removed must be marked with either attr1Name or attr2Name


Current status/limitations:
1) Internally "links" are created between Nodes one one side and Edges on the
   other. The Edge intersections become Nodes in newBody.
2) Inverse evaluations using the Node positions are used to set these Edge
   intersections. Because an inverse evaluation only returns a single result,
   there can be at most one link per Edge per Node.
3) The suite of possible links are accumulated (per Node) and anytime a Node-
   to-Node link is found within 1.25 of the shortest link, the Node-to-Node
   link is used as well and any smaller links allowing 3 possible links
   associated with the Node.
4) Multiple links from a Node are examined for short (with respect to the link
   length) Edge segments. If one is found to be below 1/3 of smallest link
   distance, then the links are removed. This is to avoid link/link
   intersections of apposing Nodes.
5) Blunt trailing edges can display cross-over links (intersecting links) when
   3 links are emitted from both trailing edge Nodes. This is avoided by
   examining the ratios of the length of smallest neighboring Edge to the link.
   If smaller than 1/2, the link on the side of the small neighbor is removed.
 
 
Future tasks:
1) A different scheme may be required so that more than one result can be
   achieved per Node/Edge intersection. This may be accomplished by using
   an inverse evaluation variant that returns multiple results. This has the
   possibility of reducing the skewness seen in some patches.
2) Remove the heuristics seen in the limitations (4-5) above. The heuristic
   seen in 3 may be OK. Both 4 and 5 have to do with link cross-overs, this
   could be accomplished by actually producing an algorithm that detects these
   situations and removes only those links that actually are problematic.
3) There are asymmetries seen is some of the cases. These are due to at least
   two reasons: (1) the use of inverse evaluations in fairly circular Edge
   regions [may be fixed by the first task above] and (2) the asymmetry seen
   in the offset curves. This may need attention!

*/

#ifdef __cplusplus
}
#endif

#endif
