# Import pyCAPS module
import pyCAPS

# Import os module
import os

# Import argparse module
import argparse

# Setup and read command line options. Please note that this isn't required for pyCAPS
parser = argparse.ArgumentParser(description = 'AFLR4 and Tetgen Pytest Example',
                                 prog = 'aflr4_and_Tetgen_PyTest',
                                 formatter_class = argparse.ArgumentDefaultsHelpFormatter)

#Setup the available commandline options
parser.add_argument('-workDir', default = ["."+os.sep], nargs=1, type=str, help = 'Set working/run directory')
parser.add_argument("-outLevel", default = 1, type=int, choices=[0, 1, 2], help="Set output verbosity")
args = parser.parse_args()

# Set analysis directory
workDir = os.path.join(str(args.workDir[0]), "AFLR4TetgenAnalysisTest")

# Load CSM file
geometryScript = os.path.join("..","csmData","cfdMultiBody.csm")
capsProblem = pyCAPS.Problem(problemName = workDir,
                             capsFile = geometryScript,
                             outLevel = args.outLevel)

# TetGen does not support wakes
capsProblem.geometry.cfgpmtr.wake = 0

# Load AFLR4 aim
aflr4 = capsProblem.analysis.create(aim = "aflr4AIM")

# Set AIM verbosity
aflr4.input.Mesh_Quiet_Flag = True if args.outLevel == 0 else False

# Optional: Explicitly write mesh files
aflr4.input.Mesh_Format = "Tecplot"

# Farfield growth factor
aflr4.input.ff_cdfr = 1.4

# Set maximum and minimum edge lengths relative to capsMeshLength
aflr4.input.max_scale = 0.2
aflr4.input.ideal_min_scale = 0.01

# Set additional meshing inputs
aflr4.input.Mesh_Length_Factor = 6
aflr4.input.curv_angle = 15

######################################
## AFRL4 executes automatically     ##
######################################

#######################################
## Build volume mesh off of surface  ##
##  mesh(es) using TetGen            ##
#######################################

# Load TetGen aim
aflr3 = capsProblem.analysis.create(aim = "tetgenAIM")

# Link the surface mesh
aflr3.input["Surface_Mesh"].link(aflr4.output["Surface_Mesh"])

# Set AIM verbosity
aflr3.input.Mesh_Quiet_Flag = True if args.outLevel == 0 else False

# Set surface mesh preservation
aflr3.input.Preserve_Surf_Mesh = True

# Optional: Explicitly write mesh files
aflr3.input.Mesh_Format = ["Tecplot", "ugrid"]

# Don't extract the update the local-to-global node connectivity
aflr3.input.Ignore_Surface_Mesh_Extraction = True

# Run AIM
aflr3.runAnalysis()
