/*
 *      CAPS: Computational Aircraft Prototype Syntheses
 *
 *      Copyright 2014-2026, Massachusetts Institute of Technology
 *      Licensed under The GNU Lesser General Public License, version 2.1
 *      See http://www.opensource.org/licenses/lgpl-2.1.php
 *
 */


/* Include vlmUtils.c to test static functions */
#include "vlmUtils.c"

#include "aimTest.h"

/* Used to test the equalSpaceSpanPanels implementation */
void test_equalSpaceSpanPanels(void *aimInfo)
{
  int i, NspanTotal = 20;
  const int numSection = 4;
  vlmSectionStruct vlmSections[4];

  for (i = 0; i < numSection; i++) {
    TEST_CHECK_SUCCESS( initiate_vlmSectionStruct(&vlmSections[i]) );
    vlmSections[i].sectionIndex = i;
  }

  vlmSections[0].xyzLE[1] = 107.620715;
  vlmSections[0].xyzLE[2] = 1.90500;

  vlmSections[1].xyzLE[1] = 31.750000;
  vlmSections[1].xyzLE[2] = 1.905000;

  vlmSections[2].xyzLE[1] = 13.335000;
  vlmSections[2].xyzLE[2] = 0.175000;

  vlmSections[3].xyzLE[1] = 0.000000;
  vlmSections[3].xyzLE[2] = -1.01600;

  TEST_CHECK_SUCCESS( vlm_equalSpaceSpanPanels(NULL, NspanTotal, numSection, vlmSections) );

  TEST_CHECK_EQUAL_INT(14, vlmSections[0].Nspan );
  TEST_CHECK_EQUAL_INT( 3, vlmSections[1].Nspan );
  TEST_CHECK_EQUAL_INT( 3, vlmSections[2].Nspan );
  TEST_CHECK_EQUAL_INT( 0, vlmSections[3].Nspan );

  for (i = 0; i < numSection; i++) {
    TEST_CHECK_SUCCESS( destroy_vlmSectionStruct(&vlmSections[i]) );
  }
}


TEST_LIST = {
    { "equalSpaceSpanPanels", test_equalSpaceSpanPanels },
    { NULL, NULL }
};

