/*
 ************************************************************************
 *                                                                      *
 * updateHelper -- build ESP/contributed/contributed from .hlp files    *
 *                                                                      *
 *             Written by John Dannenhoffer @ Geocentric Technologies   *
 *                                                                      *
 ************************************************************************
 */

/*
 * Copyright (C) 2026  John F. Dannenhoffer, III (Geocentric Technologies))
 *
 * This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *     MA  02110-1301  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <dirent.h>

/******************************************************************/
/*                                                                */
/*   main - main program                                          */
/*                                                                */
/******************************************************************/

int
main(int    argc,                       /* (in)  number of command-line arguments */
     char*  argv[])                     /* (in)  array  of command-line arguments */
{

    int  iarg, ientry, jentry, nentry;
    char command[256], title[256], arg1[256], templine[256], extraname[256];
    char *esp_root;
    char filenames[100][256];
    DIR  *folder;
    FILE *fp_html, *fp_subhtml, *fp_hlp;
    struct dirent *entry;
    void *temp;
    
    /* ---------------------------------------------------------- */

    esp_root = getenv("ESP_ROOT");
    printf("esp_root=%s\n", esp_root);

    /* create the header for contributed.html */
    printf("   Creating header\n");
    snprintf(templine, 255, "%s/ESP/contributed/contributed.html", esp_root);
    fp_html = fopen(templine, "w");
    if (fp_html == NULL) {
        printf("could not open \"%s\"\n", templine);
        exit(EXIT_FAILURE);
    }

    fprintf(fp_html, "<?xml version=\"1.0\"?>\n");
    fprintf(fp_html, "<!DOCTYPE HTML PUBLIC \"~//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n");
    fprintf(fp_html, "<meta charset=\"UTF-8\">\n\n");

    fprintf(fp_html, "<html>\n");
    fprintf(fp_html, "  <head>\n");
    fprintf(fp_html, "    <title>Contributed UDPs and UDFsl</title>\n\n");

    fprintf(fp_html, "    <style type=\"text/css\">\n");
    fprintf(fp_html, "      body {font-size: 12pt;}\n");
    fprintf(fp_html, "    </style>\n");
    fprintf(fp_html, "  </head>\n\n");

    fprintf(fp_html, "  <body>\n");
    fprintf(fp_html, "    <p><h2>Contributed UDPs and UDFs</h2>\n");

    /* table of contents in contributed.html */
    printf("   Building table of contents\n");
    fprintf(fp_html, "      <table>\n");
    for (iarg = 1; iarg < argc; iarg++) {
        fp_hlp = fopen(argv[iarg], "r");
        if (fp_hlp != NULL) {
            
            fscanf(fp_hlp, "%s %s %s", command, title, arg1);
            if (strcmp(command, "UDPRIM") != 0) {
                printf("file \"%s\" should start with \"UDPRIM\"\n", argv[iarg]);
                exit(EXIT_FAILURE);
            }
            if (strcmp(arg1, "-") == 0) {
                fprintf(fp_html, "        <tr><td><a href=\"#%s_udp\">%s</a></td></tr>\n", title, title);
            } else {
                fprintf(fp_html, "        <tr><td><a href=\"#%s_udf\">%s</a></td></tr>\n", title, title);
            }
            fclose(fp_hlp);
        }
    }
    fprintf(fp_html, "      </table>\n\n");

    /* make an entry for each UDP/UDF in contributed.html */
    for (iarg = 1; iarg < argc; iarg++) {
        printf("   Making entry for %s\n", argv[iarg]);
        fp_hlp = fopen(argv[iarg], "r");
        if (fp_hlp != NULL) {
            fscanf(fp_hlp, "%s %s %s", command, title, arg1);
            rewind(fp_hlp);

            if (strcmp(arg1, "-") == 0) {
                fprintf(fp_html, "      <p><h3 id=\"%s_udp\">%s</h3>\n", title, title);
            } else {
                fprintf(fp_html, "      <p><h3 id=\"%s_udf\">%s</h3>\n", title, title);
            }
            fprintf(fp_html, "      <pre>\n");

            while (feof(fp_hlp) == 0) {
                temp = fgets(templine, 255, fp_hlp);
                if (feof(fp_hlp) != 0) break;

                fprintf(fp_html, "%s", templine);
            }
            fclose(fp_hlp);
            fprintf(fp_html, "      </pre>\n");
            fprintf(fp_html, "      <p>\n");
        }

        /* get a directory listing of all files for this UDP/UDC */
        strcpy(templine, argv[iarg]);
        for (ientry = strlen(templine)-1; ientry >= 0; ientry--) {
            if (templine[ientry] == '/') {
                templine[ientry] = '\0';
                break;
            }
        }

        folder = opendir(templine);
        nentry = 0;
        if (folder != NULL) {
            while ((entry = readdir(folder)) != NULL) {
                strcpy(filenames[nentry++], entry->d_name);
            }
            closedir(folder);
        }

        /* sort the list alphabetically */
        for (ientry = 0; ientry < nentry; ientry++) {
            for (jentry = ientry+1; jentry < nentry; jentry++) {
                if (strcmp(filenames[ientry], filenames[jentry]) > 0) {
                    strcpy(templine,          filenames[ientry]);
                    strcpy(filenames[ientry], filenames[jentry]);
                    strcpy(filenames[jentry], templine);
                }
            }
        }

        /* add an entry for each .png file */
        for (ientry = 0; ientry < nentry; ientry++) {
            if (strstr(filenames[ientry], ".png") != NULL) {
                filenames[ientry][strlen(filenames[ientry])-4] = '\0';

                printf("      Adding an entry for %s\n", filenames[ientry]);
                fprintf(fp_html, "        <a href=\"%s.html\"> <img src=\"%s.png\" width=\"200px\"></a>\n", filenames[ientry], filenames[ientry]);

                /* count the number of files associated with this .png */
                extraname[0] = '\0';
                for (jentry = 0; jentry < nentry; jentry++) {
                    if (jentry == ientry) continue;
                    
                    if (strstr(filenames[jentry], filenames[ientry]) != NULL) {
                        if (strstr(filenames[jentry], ".csm") != NULL) {
                            continue;
                        } else {
                            strcpy(extraname, filenames[jentry]);
                            break;
                        }
                    }
                }

                /* create the sub-html file */
                strcpy(templine, esp_root);
                strcat(templine, "/ESP/contributed/");
                strcat(templine, filenames[ientry]);
                strcat(templine, ".html");

                fp_subhtml = fopen(templine, "w");
                if (fp_subhtml != NULL) {
                    fprintf(fp_subhtml, "<?xml version=\"1.0\"?>\n");
                    fprintf(fp_subhtml, "<!DOCTYPE HTML PUBLIC \"~//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n");
                    fprintf(fp_subhtml, "<meta charset=\"UTF-8\">\n\n");

                    fprintf(fp_subhtml, "<html>\n");
                    fprintf(fp_subhtml, "  <head>\n");
                    fprintf(fp_subhtml, "    <title>%s.csm</title>\n\n", filenames[ientry]);

                    fprintf(fp_subhtml, "    <style type=\"text/css\">\n");
                    fprintf(fp_subhtml, "      body {font-size: 12pt;}\n");
                    fprintf(fp_subhtml, "    </style>\n\n");

                    fprintf(fp_subhtml, "    <script>\n");
                    fprintf(fp_subhtml, "      function resizeIframe1() {\n");
                    fprintf(fp_subhtml, "          var thePicture = document.getElementById(\"picture\");\n");
                    fprintf(fp_subhtml, "          var theCode    = document.getElementById(\"code1\");\n");
                    fprintf(fp_subhtml, "          theCode.height = thePicture.scrollHeight + 'px';\n");
                    fprintf(fp_subhtml, "      }\n");
                    fprintf(fp_subhtml, "      function resizeIframe2() {\n");
                    fprintf(fp_subhtml, "          var thePicture = document.getElementById(\"picture\");\n");
                    fprintf(fp_subhtml, "          var theCode    = document.getElementById(\"code2\");\n");
                    fprintf(fp_subhtml, "          theCode.height = thePicture.scrollHeight + 'px';\n");
                    fprintf(fp_subhtml, "      }\n");
                    fprintf(fp_subhtml, "    </script>\n");
                    fprintf(fp_subhtml, "  </head>\n\n");

                    if (strlen(extraname) == 0) {
                        fprintf(fp_subhtml, "  <body>\n");
                        fprintf(fp_subhtml, "    <img id=\"picture\" src=\"%s.png\" width=\"49%%\"/>\n", filenames[ientry]);
                        fprintf(fp_subhtml, "    <iframe id=\"code1\" src=\"%s.csm.txt\" width=\"49%%\" onload=\"resizeIframe1(this)\"/></iframe>\n", filenames[ientry]);
                        fprintf(fp_subhtml, "  </body>\n");
                    } else {
                        fprintf(fp_subhtml, "  <body>\n");
                        fprintf(fp_subhtml, "    <img id=\"picture\" src=\"%s.png\" width=\"32%%\"/>\n", filenames[ientry]);
                        fprintf(fp_subhtml, "    <iframe id=\"code1\" src=\"%s.csm.txt\" width=\"32%%\" onload=\"resizeIframe1(this)\"/></iframe>\n", filenames[ientry]);
                        fprintf(fp_subhtml, "    <iframe id=\"code2\" src=\"%s\"         width=\"32%%\" onload=\"resizeIframe2(this)\"/></iframe>\n", extraname);
                        fprintf(fp_subhtml, "  </body>\n");
                    }
                    fprintf(fp_subhtml, "</html>\n");
                    
                    fclose(fp_subhtml);
                }
            }
        }
    }

    fprintf(fp_html, "  </body>\n");
    fprintf(fp_html, "</html>\n");
            
    fclose(fp_html);

    exit(EXIT_SUCCESS);
}
