# This software has been cleared for public release on 05 Nov 2020, case number 88ABW-2020-3462.

# Import Cython *.pxds 
cimport cEGADS

cdef extern from "../feaTypes.h":

    cdef int I11 "I11"
    cdef int I21 "I21"
    cdef int I22 "I22"
    cdef int I31 "I31"
    cdef int I32 "I32"
    cdef int I33 "I33"

#cimport cAIMUtil

# try:
#     from cpython.version cimport PY_MAJOR_VERSION
# except: 
#     print "Error: Unable to import cpython.version"
# #    raise ImportError
# 
# # Import Python modules
# try:
#     import sys
# except:
#     print "\tUnable to import sys module - Try ' pip install sys '"
# #    raise ImportError
# 
# try:
#     import os
# except:
#     print "\tUnable to import os module - Try ' pip install os '"
# #    raise ImportError
# 

# Python version
from cpython.version cimport PY_MAJOR_VERSION
from pyNastran.op2.op2 import OP2

#from pyNastran.op2.op2_interface.nx_tables import NX_RESULT_TABLES
#NX_RESULT_TABLES += [b'OAEROF', b'OAEROTV', b'OAERCSHM', b'OAEROSCD', b'OAEROHMD', ]

# Handles all byte to uni-code and and byte conversion. 
def _str(data,ignore_dicts = False):
        
    if PY_MAJOR_VERSION >= 3:
        if isinstance(data, bytes):
            return data.decode("utf-8")
   
        if isinstance(data,list):
            return [_str(item,ignore_dicts=True) for item in data]
        if isinstance(data, dict) and not ignore_dicts:
            return {
                    _str(key,ignore_dicts=True): _str(value, ignore_dicts=True)
                    for key, value in data.iteritems()
                    }
    return data

# open the op2 file
cdef public object nastran_modelOP2(const char *filename):
    model = OP2(debug=False)
    model.read_op2(_str(filename), combine=False)
    
    return model

# Get displacement 
cdef public int nastran_getOP2Displacements(object model, int itime, int subcaseId, 
                                            int *numGridPoint, double ***dataMatrix) except -1:
    
    cdef:
        int numData
        double **data=NULL
        
    numVariable = 8 # Grid Id, coord Id, T1, T2, T3, R1, R2, R3
  
    disp = model.displacements[subcaseId]
    txyzr = disp.data[itime, :, :]
    numData = int(len(txyzr))
    data = <double **> cEGADS.EG_alloc(numData*sizeof(double*))
    if not data: return cEGADS.EGADS_MALLOC
    
    i = 0
    for (nid, grid_type), txyzr in zip(disp.node_gridtype, txyzr):
        data[i] = <double *> cEGADS.EG_alloc(numVariable*sizeof(double))
        if not data[i]: return cEGADS.EGADS_MALLOC
        data[i][0] = nid
        data[i][1] = grid_type
        data[i][2] = txyzr[i][0]
        data[i][3] = txyzr[i][1]
        data[i][4] = txyzr[i][2]
        data[i][5] = txyzr[i][3]
        data[i][6] = txyzr[i][4]
        data[i][7] = txyzr[i][5]
        i = i+1

    numGridPoint[0] = numData
    dataMatrix[0] = data
    
    return cEGADS.EGADS_SUCCESS

# Get eigenvalue
# where variables are eigenValue, eigenValue(radians), eigenValue(cycles), generalized mass, and generalized stiffness.                                                                   MASS              STIFFNESS
cdef public int nastran_getOP2EigenValue(object model, int subcaseId, 
                                         int *numGridPoint, double ***dataMatrix) except -1:
    
    cdef:
        int numData
        double **data=NULL
        
    numVariable = 5 # EigenValue, eigenValue(radians), eigenValue(cycles), generalized mass, and generalized stiffness
  
    # require:
    #  PARAM,POST,-2
    #  PARAM,POSTEXT,YES
    key0 = list(model.eigenvalues)[0]
    eigenvalues = model.eigenvalues[key0]
    #print(eigenvalues.get_stats())
    numData = int(len(eigenvalues.eigenvalues))
    data = <double **> cEGADS.EG_alloc(numData*sizeof(double*))
    if not data: return cEGADS.EGADS_MALLOC
    
    i = 0
    for value, radian, cycle, mass, stiffness in zip(eigenvalues.eigenvalues, eigenvalues.radians, eigenvalues.cycles, eigenvalues.generalized_mass, eigenvalues.generalized_stiffness):
        data[i] = <double *> cEGADS.EG_alloc(numVariable*sizeof(double))
        if not data[i]: return cEGADS.EGADS_MALLOC
        data[i][0] = value
        data[i][1] = radian
        data[i][2] = cycle
        data[i][3] = mass
        data[i][4] = stiffness
        i = i+1

    numGridPoint[0] = numData
    dataMatrix[0] = data
    
    return cEGADS.EGADS_SUCCESS

# Get grid point weight
# where variables are eigenValue, eigenValue(radians), eigenValue(cycles), generalized mass, and generalized stiffness.                                                                   MASS              STIFFNESS
cdef public int nastran_getOP2GridPointWeight(object model, double *mass, double cg[3],
                                              double IS[3], double IQ[3], double Q[9]) except -1:

    # require:
    #  PARAM,POST,-2
    #  PARAM,POSTEXT,YES
    #  PARAM,GRDPNT,0
    key0 = list(model.grid_point_weight)[0]
    grid_point_weight = model.grid_point_weight[key0]
    #print(grid_point_weight.get_stats())
    
    cg[0] = grid_point_weight.cg[1][0]
    cg[1] = grid_point_weight.cg[0][1]
    cg[2] = grid_point_weight.cg[0][2]
    
    IS[I11] = grid_point_weight.IS[0][0] # ixx
    IS[I21] = grid_point_weight.IS[0][1] # ixy
    IS[I22] = grid_point_weight.IS[1][1] # iyy
    IS[I31] = grid_point_weight.IS[0][2] # ixz
    IS[I32] = grid_point_weight.IS[1][2] # iyz
    IS[I33] = grid_point_weight.IS[2][2] # izz

    for i in range(3):
        IQ[i] = grid_point_weight.IQ[i]
    for i in range(3):
        for j in range(3):
            Q[i + 3*j] = grid_point_weight.Q[i][j]
    
    return cEGADS.EGADS_SUCCESS

# Get objective
cdef public int nastran_getObjective(object model, int *numObjective, double **objective) except -1:

    cdef:
        int numData
        double *data=NULL
  
    objFunc = model.op2_results.responses.convergence_data.obj_initial
    numData = int(len(objFunc))
    data = <double *> cEGADS.EG_alloc(numData*sizeof(double))
    if not data: return cEGADS.EGADS_MALLOC
    
    i = 0
    while i < numData:
        data[i] = objFunc[i]
        i += 1
    
    numObjective[0] = numData
    objective[0] = data
    
    return cEGADS.EGADS_SUCCESS