#ifndef MATECONTOURS_H
#define MATECONTOURS_H

#include "egads.h"

#ifdef __ProtoExt__
#undef __ProtoExt__
#endif
#ifdef __cplusplus
extern "C" {
#define __ProtoExt__
#else
#define __ProtoExt__ extern
#endif

__ProtoExt__ int
EG_mateContours( ego body, const char *aName1, const char *aName2, ego *newBody,
                 int *ncontour, int **nent, int **contour1, int **contour2 );


/*
icode = EG_mateContours(ego body, char *attrName1, char *attrName2, ego newBody,
                        int *ncontour, int **nent, int **contr1, int **contr2)

body            input Sheet or Solid Body
attrName1       the attribute name for the first side(s)
attrName2       the attribute name for the second side(s)
newBody         resultant new Body with Nodes inserted in the appropriate places
ncontour        the returned number of sets of contours found
nent            a pointer to the returned number of Edges (and/or Nodes) 
                found in each contour (ncontour in length -- freeable)
contr1          the returned list of Edges/Nodes indices and senses that 
                represents a Face crossing contour built from the Edges with 
                attrName1 (sum of 2*nent in length -- freeable)
contr2          the returned list of Edges/Nodes indices and senses that 
                represents a Face crossing contour built from the Edges with 
                attrName2 (sum of 2*nent in length -- freeable)

Signature notes:
1) All attributed sets of Edges must be closed
2) contr1 & contr2 refer to Edge/Node indices and senses in newBody
3) contr1 & contr2 contain the complete suite of contours, where the number
   of the first set is nent[0] and if ncontour is greater than 1, the second
   set begins at contr1[nent[0]] and contr2[nent[0]], and so forth...
4) In general the entities in contr1 and contr2 are Edge indices with senses. 
   If the sense is 0 then it refers to a Node index in the Body. A Node found 
   in either list means that the corresponding Edge in the other list creates a
   fan (3 sided, vs. a 4 sided surface). You will not see a Node associated 
   with another Node.
5) The Faces to be removed must be marked with either attr1Name or attr2Name


Current status/limitations:
1) Internally "links" are created between Nodes on one side and Edges on the
   other. The Edge intersections become Nodes in newBody.
2) Inverse evaluations using the Node positions are used to set these Edge
   intersections. This is performed in Phase 1 (out of 2) where initial links
   are generated that, at a minimum touch each existing Node.
3) Phase 2 examines the Phase 1 links and adds additional links by marching
   along the segments to make "fans".
4) When determining whether a link can be made it must be shorter than 1.14
   (MAXRATIO1) of a neighboring link in Phase 1. The Phase 2 value (MAXRATIO2)
   is currently set to 1.08.
5) Multiple links from a Node are examined for short (with respect to the link
   length) Edge segments. If one is found to be below 1/3 (MINRATIO) of smallest
   link distance, then the links are removed. This is to avoid link/link
   intersections of apposing Nodes.
6) Blunt trailing edges under rare circumstances can display cross-over links
   (intersecting links) in Phase 1.
 
 
Future tasks:
1) Remove the heuristics seen in the limitations (4-5) above.
2) Rewrite Phase 1 to avoid cross-overs.
3) There are asymmetries seen is some of the cases. These are due to at least
   two reasons: (1) the use of inverse evaluations in fairly circular Edge
   regions [may be fixed by the first task above] and (2) the asymmetry seen
   in the offset curves. This may need attention!

*/

#ifdef __cplusplus
}
#endif

#endif
