#!/bin/bash -e

PREFIX="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
INSTALL=$(basename $PREFIX)
PYVER=${INSTALL%.*}
PYVER=${PYVER#*.}
ARCH=`uname -m`

BIN="$PREFIX/bin"
LIB="$PREFIX/lib/python3.${PYVER}"
CONFIG="$LIB/_sysconfigdata__linux_${ARCH}-linux-gnu.py"
SCRIPTS="`ls $BIN/*` $LIB/config-3.${PYVER}-${ARCH}-linux-gnu/Makefile $LIB/config-3.${PYVER}-${ARCH}-linux-gnu/python-config.py `ls $PREFIX/lib/pkgconfig/python*.pc` $CONFIG"
INSTALLPATH=$(echo "${PREFIX}"  | sed 's/\//\\\//g')
for f in $SCRIPTS
do
  if [[ ! $(file -bL --mime $f | grep 'binary') ]]; then
    echo "Patching '$f'"
    sed -i "s/ESP_Python_INSTALL/$INSTALLPATH/g" $f
  fi
done
