// This software has been cleared for public release on 05 Nov 2020, case number 88ABW-2020-3462.

// Structures for vortex lattice analysis - Written by Dr. Ryan Durscher AFRL/RQVC

#ifndef _AIM_UTILS_VLMTYPES_H_
#define _AIM_UTILS_VLMTYPES_H_

#include <egadsTypes.h>

typedef enum {vlmGENERIC, vlmPLANEYZ, vlmRADIAL, vlmREVOLVE, vlmANNULAR, vlmBODY} vlmSystemEnum;
typedef enum {vlmSecAirfoil, vlmSecLine, vlmSecNode, vlmSecUnknown} vlmSectionEnum;

typedef struct {

    char *name; // Control surface name

    double deflectionAngle; // Deflection angle of the control surface
    double controlGain;     //Control deflection gain, units:  degrees deflection / control variable

    double percentChord;    // Percentage along chord
    double xyzHinge[3];     // xyz location of the hinge
    double xyzHingeVec[3];  // Vector of hinge line at xyzHinge
    double hingeHeight;     // Hinge fraction of height location
    double slotGap;         // Fraction of lifting surface slot gap

    int    leOrTeOverride;  // Does the user want to override the geometry set value?
    int    leOrTe;          // Leading = 0 or trailing > 0 edge control surface

    int  deflectionDup;     // Sign of deflection for duplicated surface

    char *surfaceSymmetry;  // Control surface type of symmetry

} vlmControlStruct;

typedef struct {
    char *name; // Section Name

    ego ebody;       // Body of the section (might be flipped relative to original)
    vlmSectionEnum type;

    int sectionIndex; // Section index - 0 bias

    double xyzLE[3]; // xyz coordinates for leading edge
    int nodeIndexLE; // Leading edge node (in geometry) index with reference to xyzLE - 1 bias

    double xyzTE[3]; // xyz coordinates for trailing edge (Node or Edge mid point)
    ego teObj;       // Trailing edge object in the body
    int teClass;     // Trailing edge object class (NODE or EDGE)

    double chord;    // section chord length
    double ainc;     // section incidence angle

    double CDCL[6];  // CD(CL) function parameters

    double normal[3]; // planar normal for the section

    int    Nspan;   // number of spanwise vortices (elements)
    double Sspace;  // spanwise point distribution
    int    Sset;    // spanwise point distribution set by user

    int numControl;
    vlmControlStruct *vlmControl;

} vlmSectionStruct;

// Structure to hold structrual aerodynamic interpolation spline information
typedef struct {

    int numNames;    // number of capsSpline names
    char **names;    // capsSpline names

    double dz;       // Linear attachment flexibility
    char *meth;      // Method for the spline fit. IPS,TPS or FPS.

    char *usage;     // Spline usage flag to determine whether this spline applies to the force transformation, displacement transformation or both. FORCE, DISP or BOTH.
    int nelem;       // The number of FE elements along the local spline x-axis if using the FPS option.
    int melem;       // The number of FE elements along the local spline y-axis if using the FPS option.
    int spanLimited; // Limit the number of spline points to be between the airfoil sections.

    int numGridID;   // Number of grid IDs in grid ID set for the spline
    int *gridIDSet;  // List of grid IDs to apply spline to. size = [numGridID]

} vlmInterpSplineStruct;

typedef struct {
    char   *name; // Name of surface

    int numAttr;    // Number of capsGroup/attributes used to define a given surface
    int *attrIndex; // List of attribute map integers that correspond given capsGroups

    double Cspace;  // AVL spacing parameters
    double Sspace;

    int Cgrowth_type;  // Flightstream spacing parameters
    int Sgrowth_type;
    double Cgrowth_rate;
    double Sgrowth_rate;
    int Cperiodicity;
    int Speriodicity;
    int blendTE;

    double CLaf;

    double CDCL[6];       // CD(CL) function parameters

    int    Nchord;
    int    NspanTotal;    // Total number of spanwise vortices (elements) on the surface
    int    NspanSection;  // Number of spanwise vortices on each section of the surface

    int    nowake;
    int    noalbe;
    int    noload;
    int    compon;
    int    iYdup;

    double sortVec[3]; // Sorting direction vector. Normal vector from section surface by default.

    double x0[3];       // origin for axis of rotation of annular surface
    double axis0[3];     // direction for axis of rotation of annular surface
    double startAngle; // start/end angles for revolved surface
    double endAngle;

    int numSection; // Number of sections that make up the surface
    vlmSectionStruct *vlmSection; // Section information

    int numInterpSpline;
    vlmInterpSplineStruct *interpSpline;

    char *surfaceType;

} vlmSurfaceStruct;

#endif // _AIM_UTILS_VLMTYPES_H_
