C
C      EGADS: Electronic Geometry Aircraft Design System
C
C             FORTRAN Include
C
C      Copyright 2011-2025, Massachusetts Institute of Technology
C      Licensed under The GNU Lesser General Public License, version 2.1
C      See http://www.opensource.org/licenses/lgpl-2.1.php
C
C
C       OBJECT CLASSES
C
        INTEGER    CONTXT,   TRANSFORM,   TESSELLATION
        PARAMETER (CONTXT=0, TRANSFORM=1, TESSELLATION=2)
        INTEGER    REFERENCE
        PARAMETER (REFERENCE=5)
        INTEGER    PCURVE,    CURVE,    SURFACE
        PARAMETER (PCURVE=10, CURVE=11, SURFACE=12)
        INTEGER    NODE,    EDGE,    LOOP,    FACE
        PARAMETER (NODE=20, EDGE=21, LOOP=22, FACE=23)
        INTEGER    SHELL,    BODY,    MODEL
        PARAMETER (SHELL=24, BODY=25, MODEL=26)
        INTEGER    EEDGE,    ELOOPX,    EFACE,    ESHELL,    EBODY
        PARAMETER (EEDGE=31, ELOOPX=32, EFACE=33, ESHELL=34, EBODY=35)
C
C       MEMBER TYPES
C
C         PCURVES & CURVES
        INTEGER    LINE,   CIRCLE,   ELLIPSE,   PARABOLA
        PARAMETER (LINE=1, CIRCLE=2, ELLIPSE=3, PARABOLA=4)
        INTEGER    HYPERBOLA,   TRIMMED,   BEZIER,   BSPLINE
        PARAMETER (HYPERBOLA=5, TRIMMED=6, BEZIER=7, BSPLINE=8)
        INTEGER    OFFSET
        PARAMETER (OFFSET=9)
C
C         SURFACES
        INTEGER    PLANE,   SPHERICAL,   CYLINDRICAL,   REVOLUTION
        PARAMETER (PLANE=1, SPHERICAL=2, CYLINDRICAL=3, REVOLUTION=4)
        INTEGER    TOROIDAL,   CONICAL,   EXTRUSION
        PARAMETER (TOROIDAL=5, CONICAL=10, EXTRUSION=11)
C
C         TOPOLOGY
        INTEGER    SREVERSE,    NOMTYPE,   SFORWARD,   ONENODE
        PARAMETER (SREVERSE=-1, NOMTYPE=0, SFORWARD=1, ONENODE=1)
        INTEGER    TWONODE,   OPEN,   CLOSED,   DEGENERATE
        PARAMETER (TWONODE=2, OPEN=3, CLOSED=4, DEGENERATE=5)
        INTEGER    WIREBODY,   FACEBODY,   SHEETBODY,   SOLIDBODY
        PARAMETER (WIREBODY=6, FACEBODY=7, SHEETBODY=8, SOLIDBODY=9)
C
C	ATTRIBUTE TYPES
C
	INTEGER    ATTRINT,   ATTRREAL,   ATTRSTRING,   ATTRCSYS
	PARAMETER (ATTRINT=1, ATTRREAL=2, ATTRSTRING=3, ATTRCSYS=12)
C
C       SOLID BOOLEAN OPERATIONS
C
	INTEGER    SUBTRACTION,   INTERSECTION,   FUSION,   SPLITTER
	PARAMETER (SUBTRACTION=1, INTERSECTION=2, FUSION=3, SPLITTER=4)
C
C	SOLID BODY TYPES
C
	INTEGER    BOX,   SPHERE,   CONE,   CYLINDER,   TORUS
	PARAMETER (BOX=1, SPHERE=2, CONE=3, CYLINDER=4, TORUS=5)
C
C	NULL
C
	INTEGER*8 NULL
        PARAMETER (NULL=0)
